//
//  WCRecognitionContextModel.h
//
//
//  Created by Howard.Lin on 13/12/10.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

//#import <UIKit/UIKit.h>
#import "WCRecognitionFieldDefine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCRecognitionContextModel : NSObject
{
    @protected
     BOOL                      isCJKStringValue_;  //資料內容為中、日、韓字串
     CGRect                    recognitionRect_;
     NSString                  *contextString_;
     WCRecognitionFieldSubType recognitionFieldSubType_;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,assign) BOOL                      isCJKStringValue;
@property (nonatomic,assign) CGRect                    recognitionRect;
@property (nonatomic,copy)   NSString                  *contextString;
@property (nonatomic,assign) WCRecognitionFieldSubType recognitionFieldSubType;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

/**
 * To create WCRecognitionContextModel for the these parameters
 * @param contextString The contextString you want to show
 * @param recognitionRect The CGRect of Image
 * @param isCJKStringValue The string is Chinese, Japan, or Koreca
 */
+ (WCRecognitionContextModel *)recognitionContextModelWithContextString:(NSString *)contextString
                                                        recognitionRect:(CGRect)recognitionRect
                                                       isCJKStringValue:(BOOL)isCJKStringValue;

@end
