//
//  WCDisplayNameController.h
//

#import "WCDisplayNameDefine.h"


@interface WCDisplayNameController : NSObject


/**
 * 產生包含姓，名，中間名，前綴，後綴的display name
 * @param firstName 名
 * @param lastName 姓
 * @param middleName 中間名
 * @param prefix 前綴
 * @param suffix 後綴
 * @param isEasternName 是否為東方語系姓名
 * @param eastOrder 東方姓名順序
 * @param westOrder 西方姓名順序
 * @return NSString 依參數產生的display name
 */
+ (NSString *)displayNameWithFirstName:(NSString *)firstName
                              lastName:(NSString *)lastName
                            middleName:(NSString *)middleName
                                prefix:(NSString*)prefix
                                suffix:(NSString*)suffix
                         isEasternName:(BOOL)isEasternName
                             eastOrder:(WCDisplayNameOrder)eastOrder
                             westOrder:(WCDisplayNameOrder)westOrder;

/**
 * 產生包含姓，名，中間名，前綴，後綴的display name
 * @param firstName 名
 * @param lastName 姓
 * @param middleName 中間名
 * @param prefix 前綴
 * @param suffix 後綴
 * @param eastOrder 東方姓名順序
 * @param westOrder 西方姓名順序
 * @return NSString 依參數產生的display name
 */
+ (NSString *)displayNameWithFirstName:(NSString *)firstName
                              lastName:(NSString *)lastName
                            middleName:(NSString *)middleName
                                prefix:(NSString*)prefix
                                suffix:(NSString*)suffix
                             eastOrder:(WCDisplayNameOrder)eastOrder
                             westOrder:(WCDisplayNameOrder)westOrder;

/**
 * 產生包含姓，名的display name
 * @param firstName 名
 * @param lastName 姓
 * @param isEasternName 是否為東方語系姓名
 * @param eastOrder 東方姓名順序
 * @param westOrder 西方姓名順序
 * @return NSString 依參數產生的display name
 */
+ (NSString *)displayNameWithFirstName:(NSString *)firstName
                              lastName:(NSString *)lastName
                         isEasternName:(BOOL)isEasternName
                             eastOrder:(WCDisplayNameOrder)eastOrder
                             westOrder:(WCDisplayNameOrder)westOrder;

/**
 * 產生包含姓，名的display name
 * @param firstName 名
 * @param lastName 姓
 * @param eastOrder 東方姓名順序
 * @param westOrder 西方姓名順序
 * @return NSString 依參數產生的display name
 */
+ (NSString *)displayNameWithFirstName:(NSString *)firstName
                              lastName:(NSString *)lastName
                             eastOrder:(WCDisplayNameOrder)eastOrder
                             westOrder:(WCDisplayNameOrder)westOrder;


@end
