//
//  WCGroupModel.h
//  WorldCard series
//
//  Created by Eddie on 2012/3/22.
//  Modified by Andrew on 2015/7/10.
//  Copyright 2011 Penpower. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface WCGroupModel : NSObject

//////////////////////////////////////////////////
// common

@property (nonatomic, assign) NSInteger sourceID;
@property (nonatomic, assign) NSInteger ID;
@property (nonatomic, copy) NSString *name;
@property (nonatomic, assign) NSInteger cardCount;
@property (nonatomic, assign) NSInteger order;
@property (nonatomic, copy) NSDate *modifiedTime;
@property (nonatomic, assign) BOOL editable;


//////////////////////////////////////////////////
// for WorldCardTeam

/// 群組guid
@property (nonatomic, retain) NSString *guid;

/// 父類別guid
@property (nonatomic, retain) NSString *superGroupGuid;

/// 子類別groupModel array
@property (nonatomic, retain) NSMutableArray<WCGroupModel*> *subGroups;

/// 釘選順序（0代表未釘選）
@property (nonatomic, assign) NSInteger pinnedOrder;

/// 是否勾選
@property (nonatomic, assign) BOOL isChecked;

/// 是否展開
@property (nonatomic, assign) BOOL isExpanded;

/// 幫助(掃描)者guid
@property (nonatomic, retain) NSString *helper;

/// 擁有者guid
@property (nonatomic, retain) NSString *owner;

@end
