//
//  WCCardModel.h
//  WorldCard series
//

#import "WCFieldModel.h"
#import "WCSourceDefine.h"
#import "WCGroupDefine.h"
#import "WCTagMaskDefine.h"
#import "WCImageDefine.h"
#import "PPSectionIndexDefine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
/// Sort descriptor裡需要用到的key（需和property的名稱一致）

#define WCCM_SortKey_DisplayName        @"displayName"
#define WCCM_SortKey_DisplayCompany     @"displayCompany"
#define WCCM_SortKey_DisplayJobTitle    @"displayJobTitle"
#define WCCM_SortKey_CreatedTime        @"createdTime"

////////////////////////////////////////////////////////////////////////////////////////////////////

#define WCCM_MODIFY_kAdd		@"WCCM_MODIFY_kAdd"
#define WCCM_MODIFY_kDelete		@"WCCM_MODIFY_kDelete"
#define WCCM_MODIFY_kUpdate		@"WCCM_MODIFY_kUpdate"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCCardModel : NSObject

/// Unique ID of Card
@property (nonatomic, copy) NSString *ID;

/// Source ID (for WorldCardTeam Mac)
@property (nonatomic, assign) WC_SourceID sourceID;

/// 此名片所屬的群組列表 (groupID is NSString)
@property (nonatomic, readonly) NSArray *groupIDArray;

/// 主要顯示姓名
@property (nonatomic, copy) NSString *displayName;

/// 主要顯示公司
@property (nonatomic, copy) NSString *displayCompany;

/// 主要顯示職稱
@property (nonatomic, copy) NSString *displayJobTitle;

/// 主要顯示電話
@property (nonatomic, copy) NSString *displayPhone;

/// 主要顯示地址
@property (nonatomic, copy) NSString *displayAddress;

/// 主要顯示GPS位址
@property (nonatomic, copy) NSString *displayGPS;

/// 這邊是儲存所有排序模式，index模式的組合，要取得目前真正的sectionTitle,請用|displaySectionTitleWithSortByField:indexingMode|
@property (nonatomic, copy) NSString *sectionTitle;

/// 建立時間
@property (nonatomic, copy) NSDate *createdTime;

/// 修改時間
@property (nonatomic, copy) NSDate *modifiedTime;

/// 正面辨識語系
@property (nonatomic, assign) NSInteger frontRecogLang;

/// 反面辨識語系
@property (nonatomic, assign) NSInteger backRecogLang;

/// 所有欄位資料
@property (nonatomic, readonly) NSMutableDictionary *fieldArrayDict;

/// 是否被選取
@property (nonatomic, assign) BOOL isSelected;

/// 所屬Tag
@property (nonatomic, assign) WC_TagMask tagMask;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WorldCardMac專用

/// 名片包含的影像 (WorldCardMac專用)
@property (nonatomic, assign) WC_ImageType containImageType;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WorldCardTeam專用

/// 建立者 (WorldCardTeam專用)
@property (nonatomic, copy) NSString *creator;

/// 擁有者 (WorldCardTeam專用)
@property (nonatomic, copy) NSString *owner;

/// 修改者 (WorldCardTeam專用)
@property (nonatomic, copy) NSString *editor;

/// 可檢視用戶列表 (WorldCardTeam專用)
@property (nonatomic, copy) NSArray *sharedAccountGUIDArray;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - visible account methods

/**
 * Append shared accounts
 *
 * @param guids - Array of accounts' GUID
 */
- (void)appendSharedAccountGUIDWithGuids:(NSArray *)guids;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - card group method

/**
 * Add group data
 *
 * @param groupID One WC_GroupID
 */
- (void)addGroupID:(WC_GroupID)groupID;

/**
 * Set group data
 *
 * @param groupIDArray Array of groupID "string"
 * @param isInitCard 是否在初始化卡片資料，例如讀取資料時呼叫需填YES，編輯資料時新增欄位請填NO。
 */
- (void)setGroupIDArray:(NSArray *)groupIDArray isInitCard:(BOOL)isInitCard;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - card field method

/**
 * Get field data by specified type
 *
 * @param fieldType WC_FieldType
 * @return Array of WCFieldModel
 */
- (NSMutableArray *)fieldArrayWithType:(WC_FieldType)fieldType;

/**
 * Add field
 *
 * @param fieldModel Instance of WCFieldModel
 */
- (void)addField:(WCFieldModel *)fieldModel;

/**
 * Insert field
 *
 * @param fieldModel Instance of WCFieldModel
 * @param index be inserted
 */
- (void)insertField:(WCFieldModel *)fieldModel atIndex:(NSInteger)index;

/**
 * Remove field by specified instance
 *
 * @param fieldModel WCFieldModel to be removed
 */
- (void)removeField:(WCFieldModel *)fieldModel;


/**
 Remove field by fieldType and index

 @param fieldType One of WC_FieldType
 @param index Index of field in fieldArray
 */
- (void)removeFieldWithType:(WC_FieldType)fieldType index:(NSInteger)index;


/**
 * Move field to first field
 *
 * @param fieldType One of WC_FieldType
 * @param index Index of field in fieldArray
 */
- (void)moveFieldToFirstWithType:(WC_FieldType)fieldType index:(NSInteger)index;


/**
 * Update field data
 *
 * @param fieldModel WCFieldModel to be updated
 */
- (void)updateField:(WCFieldModel *)fieldModel;


/**
 * Get field data by specified field type & ID
 *
 * @param fieldType One of WC_FieldType
 * @param fieldID Field ID
 * @return Instance of WCFieldModel
 */
- (WCFieldModel *)fieldWithType:(WC_FieldType)fieldType ID:(NSInteger)fieldID;


/**
 * Get field data by specified field type & Index
 *
 * @param fieldType One of WC_FieldType
 * @param fieldIndex Field index
 * @return Instance of WCFieldModel
*/
- (WCFieldModel *)fieldWithType:(WC_FieldType)fieldType index:(NSInteger)fieldIndex;


/**
 * Get all field count
 *
 * @return Field count
 */
- (NSInteger)totalFieldCount;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - other method

/// 找出空的位置塞入subType2資料
- (WCFieldModel *)insertSubType2Field:(WCFieldModel *)subType2Field;

/// new card model with display data only
- (WCCardModel *)copyCardWithDisplayData;

/// add searched field ID
- (void)addSeachedFieldID:(NSInteger)fieldID;

/// get all searched field ID
- (NSMutableArray *)searchedFieldIDs;

/// check if field value exist
- (BOOL)isFieldValueExist:(WCFieldModel *)fieldModel inArray:(NSArray *)existFieldArray;

/// remove recogRect in all fields
- (void)removeRecogRectInAllFields;

/// remove recogRect in all fields
- (void)removeRecogRectInAllFieldsWithFieldSource:(WC_FieldSource)fieldSource;

/// check if having detail field data
- (BOOL)hasFieldData;

/// remove field with specified source
- (void)removeFieldWithSource:(WC_FieldSource)fieldSource;

/// remove empty fields
- (void)removeEmptyFields;

/// field count of type
- (NSInteger)fieldCountWithFieldType:(WC_FieldType)fieldType;

/// reset field order
- (void)resetAllFieldOrder;

/// 檢查名片資料是否屬於指定 group
- (BOOL)isBelongToGroupID:(WC_GroupID)groupID;

/// 檢查名片資料是否屬於指定 source + group
- (BOOL)isBelongToSourceID:(WC_SourceID)sourceID groupID:(WC_GroupID)groupID;

/// 取得辨識語系對應的語系代碼
- (NSString *)languageCodeWithFieldSource:(WC_FieldSource)fieldSource;

/// 取得欄位辨識語系
- (NSInteger)recognitionlanguageWithFieldSource:(WC_FieldSource)fieldSource;

/// 檢查是否在相同群組
- (BOOL)isSameGroupIDArray:(NSArray *)groupIDArray;

/// 7.1.0 清除全部地址中的GPS資訊 (儲存後要清除所有gps資訊)
- (void)clearAllAddressGPS;

/// 取得顯示用的sectionTitle
- (NSString *)displaySectionTitleWithSortByField:(WC_SortedByField)sortByField indexingMode:(PPSIC_Mode)indexingMode;

/// 複製所有資料到指定的cardModel
- (void)copyValueToCardModel:(WCCardModel *)cardModel zone:(NSZone *)zone;

/// 將特定欄位的首字進行大寫處理
- (void)capitalizedString;

/// card的簡單描述，通常用在log。
- (NSString *)simpleDescription;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - combine method

/**
 取得欄位數量上限

 @param fieldType 種類
 @return 數量上限
 */
- (NSUInteger)fieldMaxCountWithType:(WC_FieldType)fieldType;

/// combine other card
- (void)combineCard:(WCCardModel *)cardModel;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - fix field count

/// 多的欄位放到note
- (void)fixFieldCount;




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - sort method

/// 姓名如果第一個不是正面CJK，就重排
- (void)sortNameByFrontCJKFirst;

/// 公司如果第一個不是正面CJK，就重排
- (void)sortCompanyByFrontCJKFirst;

/// 電話重新排序
- (void)sortPhoneFields;

@end
