//
//  ContactEditNavigationBarView.h
//
//  Created by Howard.Lin on 13/12/24.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPNavigationBarView.h"
#import "PPButton.h"
#import "WCContactEditViewController+PublicParameterDefine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, ContactEditNavigationBarViewButtonTag)
{
    ContactEditNavigationBarViewButtonTag_Cancel = 1,
    ContactEditNavigationBarViewButtonTag_Favorite,
    ContactEditNavigationBarViewButtonTag_Done,
    ContactEditNavigationBarViewButtonTag_More,
    
    // WCT only 幫同事掃描
    ContactEditNavigationBarViewButtonTag_Next,
    ContactEditNavigationBarViewButtonTag_Note,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, ContactEditNavigationBarViewButtonGuideIndex)
{
    ContactEditNavigationBarViewButtonGuideIndex_More = 1000,
    ContactEditNavigationBarViewButtonGuideIndex_Next,
    ContactEditNavigationBarViewButtonGuideIndex_Done,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@class ContactEditNavigationBarView;

@protocol ContactEditNavigationBarViewDelegate <NSObject>

@required
- (void)contactEditNavigationBarView:(ContactEditNavigationBarView *)contactEditNavigationBarView
                            ppButton:(PPButton *)button
                    withControlEvent:(UIControlEvents)event;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface ContactEditNavigationBarView : PPNavigationBarView <PPButtonDelegate>

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,assign)   id<ContactEditNavigationBarViewDelegate> delegate;
@property (nonatomic,readonly) PPButton                                 *cancelButton;
@property (nonatomic,readonly) PPButton                                 *doneButton;
@property (nonatomic,readonly) PPButton                                 *moreButton;
@property (nonatomic,readonly) PPButton                                 *favoriteButton;


@property (nonatomic, assign, readonly) WCContactEditViewControllerLayout layoutMode;
// !! only display when layoutMode==WCContactEditViewControllerLayout_HelpScan
@property (nonatomic,readonly) PPButton                                 *nextButton;
@property (nonatomic,readonly) PPButton                                 *noteButton;


- (instancetype)initWithFrame:(CGRect)frame layout:(WCContactEditViewControllerLayout)layout;
@end
