//
//  WCContactAccessToolController.h
//  Pods
//
//  Created by sanhue on 2015/8/7.
//
//

#import <Foundation/Foundation.h>

typedef void(^WCImagePickerCompletion)(UIImage *pickedImage);

typedef void(^WCImagePickerCompletionWithRecognitionTitle)(UIImage *pickedImage, NSInteger recogLanguageCode);

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCImagePickerController : NSObject


/**
 * 顯示MyCard用的Load圖，單張且要選擇語系
 * @param viewController 從哪一個頁面present
 * @param recogLanguageCode 預設辨識語系
 * @param recogLanguageModels 辨識語系列表
 * @param completion 完成後的回傳block, cancel不會進來，會直接結束
 */
+ (void)showMyCardSelectImageFromViewController:(UIViewController *)viewController
                              recogLanguageCode:(NSUInteger)recogLanguageCode
                            recogLanguageModels:(NSArray*)recogLanguageModels
                                     completion:(WCImagePickerCompletionWithRecognitionTitle)completion;

/**
 * 顯示MyCard用相機
 * @param viewController 從哪一個頁面present
 * @param recogLanguageCode 預設辨識語系
 * @param recogLanguageModels 辨識語系列表
 * @param completion 完成後的回傳block, cancel不會進來，會直接結束
 */
+ (void)showMyCardCameraFromViewController:(UIViewController *)viewController
                         recogLanguageCode:(NSUInteger)recogLanguageCode
                       recogLanguageModels:(NSArray*)recogLanguageModels
                                completion:(WCImagePickerCompletionWithRecognitionTitle)completion;


/**
 * 顯示相簿
 * @param viewController 從哪一個頁面present
 * @param completion 完成後的回傳block, cancel不會進來，會直接結束
 */
+ (void)showAlbumFromViewController:(UIViewController *)viewController completion:(WCImagePickerCompletion)completion;

/**
 * 顯示相機
 * @param viewController 從哪一個頁面present
 * @param completion 完成後的回傳block, cancel不會進來，會直接結束
 */
+ (void)showCameraFromViewController:(UIViewController *)viewController completion:(WCImagePickerCompletion)completion;


/**
 * 顯示系統相機
 * @param viewController 從哪一個頁面present
 * @param completion 完成後的回傳block, cancel不會進來，會直接結束
 */
+ (void)showSystemCameraFromViewController:(UIViewController *)viewController completion:(WCImagePickerCompletion)completion;

@end
