//
//  WCCaptureViewController.h
//
//

#import "PPViewController.h"
#import "PPCameraView.h"
#import "WCCaptureViewController+TypeDefine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@class CVCBaseCaptureController;
@class WCCaptureViewController;

@protocol WCCaptureViewControllerDelegate <NSObject>
@optional

/**
 * 取得辨識語系字串
 *
 * @param captureViewController - WCCaptureViewController instance
 * @param captureSide - Current capture side, CaptureSide_Front or CaptureSide_Back.
 * @return Recognition language string array
 */
- (NSArray *)captureViewController:(WCCaptureViewController *)captureViewController
     recogLanguagesWithCaptureSide:(WCCaptureViewController_CaptureSide)captureSide;


/**
 *  目前正反面選擇的辨識語系
 *
 *  @param captureViewController WCCaptureViewController instance
 *  @param recogLanguage         language string
 *  @param captureSide           Current capture side, CaptureSide_Front or CaptureSide_Back.
 */
- (void)captureViewController:(WCCaptureViewController *)captureViewController
       didSelectRecogLangauge:(NSString *)recogLanguage
              withCaptureSide:(WCCaptureViewController_CaptureSide)captureSide;


/**
 * Ask should capture image or not
 *
 * @param captureViewController - WCCaptureViewController instance
 * @param captureSide - Front or back side
 * @param isDoubleSideMode - Is in capture double side mode
 * @return YES if can capture.
 */
- (BOOL)captureViewController:(WCCaptureViewController *)captureViewController
shouldCaptureImageWithCaptureSide:(WCCaptureViewController_CaptureSide)captureSide
             isDoubleSideMode:(BOOL)isDoubleSideMode;


/**
 * Did capture image
 *
 * @param captureViewController - WCCaptureViewController instance
 * @param image - Captured image
 * @param recogLanguage - Select language for recognition
 * @param isDoubleSideMode - Is in capture double side mode
 */
- (void)captureViewController:(WCCaptureViewController *)captureViewController
              didCaptureImage:(UIImage *)image
                recogLanguage:(NSString *)recogLanguage
             isDoubleSideMode:(BOOL)isDoubleSideMode;


/**
 * Did recognized QRCode
 *
 * @param captureViewController - WCCaptureViewController instance
 * @param string - Captured image
 */
- (void)captureViewController:(WCCaptureViewController *)captureViewController didRecongizeQRCodeString:(NSString *)string;


/**
 * Ask if should change to next mode
 *
 * @param captureViewController - WCCaptureViewController instance
 * @param captureMode - WCCaptureViewController_CaptureMode that will be chage to.
 * @retutn YES if can be changed to the new mode.
 */
- (BOOL)captureViewController:(WCCaptureViewController *)captureViewController
    shouldChangeToCaptureMode:(WCCaptureViewController_CaptureMode)captureMode;


/**
 * Click cancel button
 *
 * @param captureViewController - WCCaptureViewController instance
 */
- (void)captureViewControllerDidClickCancel:(WCCaptureViewController *)captureViewController;


/**
 * Click done button
 *
 * @param captureViewController - WCCaptureViewController instance
 */
- (void)captureViewControllerDidClickDone:(WCCaptureViewController *)captureViewController;


/**
 * Skip card back side in double-side-mode
 *
 * @param captureViewController - WCCaptureViewController instance
 */
- (void)captureViewControllerSkipBackSide:(WCCaptureViewController *)captureViewController;


/**
 * Request to show dock promotion
 *
 * @param captureViewController - WCCaptureViewController instance
 */
- (void)captureViewControllerShowDockPromotion:(WCCaptureViewController *)captureViewController;


@end





////////////////////////////////////////////////////////////////////////////////////////////////////

/// Integrated capture controller
@interface WCCaptureViewController : PPViewController

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Property

/// Delegate
@property (nonatomic, assign) id<WCCaptureViewControllerDelegate> delegate;

/// 目前已經拍照的數量
@property (nonatomic, assign) NSInteger captureCount;

/// 目前拍哪一面
@property (nonatomic, assign) WCCaptureViewController_CaptureSide captureSide;

/// 可用的辨識語系，第一個就是預設的辨識語系。(NSString array)
@property (nonatomic, retain) NSArray *recogLanguages;

/// 可用的拍照模式，輸入順序就是選單順序。(NSNumber array with WCCaptureViewController_CaptureMode)
@property (nonatomic, retain) NSArray *supportCaptureModes;

/// 目前使用的拍照模式，所有參數設定完才能設定此參數。
@property (nonatomic, assign) WCCaptureViewController_CaptureMode activeCaptureMode;


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Class methods


/**
 * Presennt capture view with camera access permission check (for capture image only)
 *
 * @param viewController - Super view controller
 * @param delegate - delegate
 * @param captureSide - 設定為CaptureSide_Front或CaptureSide_Back會顯示左下角語系選擇按鈕；設定為CaptureSide_None則不會顯示。
 * @param presentCompletion - Completion block
 */
+ (void)presentSingleManualModeFromViewController:(UIViewController *)viewController
                                         delegate:(id<WCCaptureViewControllerDelegate>)delegate
                                      captureSide:(WCCaptureViewController_CaptureSide)captureSide
                                presentCompletion:(void (^)(BOOL success))presentCompletion;


/**
 * Presennt capture view with camera access permission check
 *
 * @param viewController - Super view controller
 * @param delegate - delegate
 * @param captureSide - Launch in front/back side mode
 * @param captureCount - Already captured count
 * @param supportCaptureModes - Support capture modes
 * @param activeCaptureMode - Active capture mode
 * @param presentCompletion - Completion block
 */
+ (void)presentFromViewController:(UIViewController *)viewController
                         delegate:(id<WCCaptureViewControllerDelegate>)delegate
                      captureSide:(WCCaptureViewController_CaptureSide)captureSide
                     captureCount:(NSInteger)captureCount
              supportCaptureModes:(NSArray *)supportCaptureModes
                activeCaptureMode:(WCCaptureViewController_CaptureMode)activeCaptureMode
                presentCompletion:(void (^)(BOOL success))presentCompletion;

/**
 * Set docking capture mode auto detection of QRCode pattern
 *
 * @param enabled - enable or not, default is YES.
 */
+ (void)setDockingCaptureAutoDetectionEnabled:(BOOL)enabled;

/**
 * Get docking capture mode auto detection status
 *
 * @return Enable or not, default is YES.
 */
+ (BOOL)dockingCaptureAutoDetectionEnabled;

/**
 * Get log path
 *
 * @return log path
 */
+ (NSString *)logDirPath;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Inherit Method

// 暫時先這樣，方便外部新增拍照介面
- (NSString *)captureModeStringWithMode:(WCCaptureViewController_CaptureMode)captureMode;

- (CVCBaseCaptureController *)captureControllerWithCaptureMode:(WCCaptureViewController_CaptureMode)captureMode;

@end
