//
//  WCImageBrowseViewController.h
//
//  Created by Howard.Lin on 13/11/21.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPViewController.h"
#import "PPImageBrowseViewController.h"

#import "WCImageBrowseBottomBarView.h"
#import "WCImageBrowseTopBarView.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, WCImageBrowseViewControllerMode)
{
    WCImageBrowseViewControllerMode_NewCard, //新增名片模式
    WCImageBrowseViewControllerMode_AddCard, //加入名片模式 (沒有，正反面的選擇)
};


////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, WCImageBrowseViewControllerAction)
{
    WCImageBrowseViewControllerAction_CaptureBackCard,
    WCImageBrowseViewControllerAction_Done,
    WCImageBrowseViewControllerAction_Exit,
    WCImageBrowseViewControllerAction_NextCard,
};

//////////////////////////////////////////////////

@class WCImageBrowseViewController;

@protocol WCImageBrowseViewControllerDelegate <NSObject>

@required

 - (void)browseImageViewController:(WCImageBrowseViewController *)browseImageViewController
                              action:(WCImageBrowseViewControllerAction)action;

@optional
 - (void)browseImageViewController:(WCImageBrowseViewController *)browseImageViewController willAnimateRotationToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCImageBrowseViewController : PPImageBrowseViewController <WCImageBrowseTopBarViewDelegate,WCImageBrowseBottomBarViewDelegate>

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property
@property (nonatomic,assign)   id<WCImageBrowseViewControllerDelegate>   delegate;
@property (nonatomic,retain)   id                                        userInfo;
@property (nonatomic,assign)   WCImageBrowseViewControllerMode           imageBrowseViewControllerMode;
@property (nonatomic,retain)   UIImage                                   *sourceImage; //辨識的圖片
//亮化
@property (nonatomic,assign)   BOOL                                      imageLight;
//前背景分離
@property (nonatomic,assign)   BOOL                                      imageSegment;
@property (nonatomic,assign)   BOOL                                      showRearCaptureButton;
@property (nonatomic,assign)   BOOL                                      showNextCaptureButton; // default: YES
@property (nonatomic,assign)   NSUInteger                                totalNumberOfImage;
@property (nonatomic,assign)   CGFloat                                   topBarViewHeight;
@property (nonatomic,assign)   CGFloat                                   bottomBarViewHeight;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

- (void)showBusyView:(BOOL)show withSuperView:(UIView *)superView;

@end
