//
//  WCCSVDataController.h
//

#import <Foundation/Foundation.h>

// Define
#import "WCCSVDataController+ParameterDefine.h"

#import "PPCSVData.h"
#import "WCCardModel.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
/// WCCSVDataControllerDelegate

@class WCCSVDataController;
@protocol WCCSVDataControllerDelegate <NSObject>
@optional

/**
 * Request field data to write
 *
 * @param csvDataController - Data controller instance
 * @param cardID - Card that need get field data
 * @return WCCardModel with field data of card
 */
- (WCCardModel *)csvDataContrller:(WCCSVDataController *)csvDataController
       cardModelToWriteWithCardID:(NSString *)cardID;

/**
 * Request group name
 *
 * @param csvDataController - Data controller instance
 * @param groupID - Group identifier need to get name
 * @return NSString with group name
 */
- (NSString *)csvDataContrller:(WCCSVDataController *)csvDataController
   groupNameToWriteWithGroupID:(WC_GroupID)groupID;


/**
 * Notify one card is should write
 *
 * @param csvDataController - Data controller instance
 * @param index - Write card index
 * @param totalCount - Total count
 @return YES, to write
 */
- (BOOL)csvDataContrller:(WCCSVDataController *)csvDataController
shouldWriteCardWithIndex:(NSInteger)index
              totalCount:(NSInteger)totalCount;


/**
 * Notify one card is write finish
 *
 * @param csvDataController - Data controller instance
 * @param index - Write card index
 * @param totalCount - Total count
 */
- (void)csvDataContrller:(WCCSVDataController *)csvDataController
   didWriteCardWithIndex:(NSInteger)index
              totalCount:(NSInteger)totalCount;



/**
 Get CSV Data dictoinary
 
 @param csvDataController Data controller instance
 @param sourceRowEntryDataArray Source CSV Row EntryData
 @param csvDataArray CSV Data Array
 @param path              CSV File's path
 */
- (void)csvDataContrller:(WCCSVDataController *)csvDataController
 sourceRowEntryDataArray:(NSArray *)sourceRowEntryDataArray
            csvDataArray:(NSArray *)csvDataArray
                withPath:(NSString *)path;



/**
 Notify one file is readed finish
 
 @param csvDataController Data controller instance
 @param index             Read file index
 @param totalCount        Total count
 */
- (void)csvDataContrller:(WCCSVDataController *)csvDataController
    didReadFileWithIndex:(NSInteger)index
              totalCount:(NSUInteger)totalCount;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCCSVDataController : NSObject

/**
 * Initialize
 *
 * @param delegate - Instance that can handle WCXFDataControllerDelegate
 * @return WCXFDataController instance
 */
- (instancetype)initWithDelegate:(id<WCCSVDataControllerDelegate>)delegate;


/**
 * Write CSV
 *
 * @param filePath - CSV file path
 * @param cardIDs - Cards that wnat to write
 * @param format - Data format
 * @param willSendByEmail - 檔案是否經由email發送（換行格式會不同，經由email發送的檔案因為系統會自行加上0x0D，所以換行只有0x0A）
 * @param error - return error
 * @return YES if success
 */
- (BOOL)writeFileWithPath:(NSString *)filePath
                  cardIDs:(NSArray *)cardIDs
                   format:(WCCSVDataController_Format)format
          willSendByEmail:(BOOL)willSendByEmail
                    error:(NSError **)error;


/**
 Read CSV
 
 @param filePaths The Array of File path
 @param error     return error
 
 @return YES if success
 */
- (BOOL)readFileWithPaths:(NSArray *)filePaths
                    error:(NSError **)error;



/**
 cardModel From TypesArray and ValueStringArray

 @param typesArray       The Array of @(WCFieldType)
 @param valueStringArray The Array of @(String)
 @param error            returnError

 @return cardModel
 */
- (WCCardModel *)cardModelFromTypesArray:(NSArray *)typesArray
                        valueStringArray:(NSArray *)valueStringArray
                                   error:(NSError **)error;
@end
