//
//  PPTextFieldTableViewCell.h
//  
//
//  Created by Mike on 13/5/15.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPTableViewCell.h"
#import "CustomRectTextField.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@class PPTextFieldTableViewCell;
@protocol PPTextFieldTableViewCellDelegate <NSObject>
@optional
- (BOOL)ppTextFieldTableViewCell:(PPTextFieldTableViewCell *)textFieldTableViewCell shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string;
- (void)ppTextFieldTableViewCellDidBeginEditing:(PPTextFieldTableViewCell *)textFieldTableViewCell;
- (void)ppTextFieldTableViewCellDidChanged:(PPTextFieldTableViewCell *)textFieldTableViewCell;
- (void)ppTextFieldTableViewCellDidEndEditing:(PPTextFieldTableViewCell *)textFieldTableViewCell;
- (BOOL)ppTextFieldTableViewCellShouldBeginEditing:(PPTextFieldTableViewCell *)textFieldTableViewCell;
- (BOOL)ppTextFieldTableViewCellShouldClear:(PPTextFieldTableViewCell *)textFieldTableViewCell;
- (BOOL)ppTextFieldTableViewCellShouldEndEditing:(PPTextFieldTableViewCell *)textFieldTableViewCell;
- (BOOL)ppTextFieldTableViewCellShouldReturn:(PPTextFieldTableViewCell *)textFieldTableViewCell;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPTextFieldTableViewCell : PPTableViewCell <UITextFieldDelegate>
{
@protected
    CustomRectTextField                     *textField_;
    NSUInteger                              maxLength_;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property(nonatomic,assign)     id<PPTextFieldTableViewCellDelegate>    delegate;
@property(nonatomic,readonly)   CustomRectTextField                     *textField;
@property(nonatomic,assign)     NSUInteger                              maxLength;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Intended For Subclasses Method

- (void)textFieldDidBeginEditing;
- (void)textFieldDidChange;
- (void)textFieldDidEndEditing;
- (BOOL)textFieldShouldBeginEditing;
- (BOOL)textFieldShouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string;
- (BOOL)textFieldShouldClear;
- (BOOL)textFieldShouldEndEditing;
- (BOOL)textFieldShouldReturn;

@end
