//
//  PPSyncRecordController.h
//  
//
//  Created by Mike Shih on 12/03/15.
//  Copyright (c) 2012年 Penpower. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "PPSQLiteController.h"
#import "PPSyncRecordModel.h"

/////////////////////////////////////////////////////////////////////////////////////////////////////////
//Version Define

#define PPSyncRecordVersionMajor_1          1   //(1.0)
#define PPSyncRecordVersionMajor_2          2
#define PPSyncRecordVersionMinor_0          0

/////////////////////////////////////////////////////////////////////////////////////////////////////////

#define PPSyncRecordVersionMajor_Current    PPSyncRecordVersionMajor_2
#define PPSyncRecordVersionMinor_Current	PPSyncRecordVersionMinor_0

/////////////////////////////////////////////////////////////////////////////////////////////////////////

typedef enum
{
	PPSyncRecordType_Local = 0,
	PPSyncRecordType_Remote,
}PPSyncRecordType;

/////////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPSyncRecordController : PPSQLiteController

/////////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma - Instance Methods

- (BOOL)deleteAllSyncRecordWithError:(NSError **)error;
- (BOOL)deleteGroupSyncRecordWithUniqueID:(NSString *)uniqueID syncRecordType:(PPSyncRecordType)syncRecordType error:(NSError **)error;
- (BOOL)deleteCardSyncRecordWithUniqueID:(NSString *)uniqueID syncRecordType:(PPSyncRecordType)syncRecordType error:(NSError **)error;
- (BOOL)insertGroupSyncRecordWithSyncRecordModel:(PPSyncRecordModel *)syncRecordModel error:(NSError **)error;
- (BOOL)insertCardSyncRecordWithSyncRecordModel:(PPSyncRecordModel *)syncRecordModel error:(NSError **)error;
- (BOOL)isFindGroupSyncRecordModelWithUniqueID:(NSString *)uniqueID syncRecordType:(PPSyncRecordType)syncRecordType error:(NSError **)error;
- (BOOL)isFindCardSyncRecordModelWithUniqueID:(NSString *)uniqueID syncRecordType:(PPSyncRecordType)syncRecordType error:(NSError **)error;
- (BOOL)updateGroupSyncRecordWithSyncRecordModel:(PPSyncRecordModel *)syncRecordModel error:(NSError **)error;
- (BOOL)updateCardSyncRecordWithSyncRecordModel:(PPSyncRecordModel *)syncRecordModel error:(NSError **)error;
- (PPSyncRecordModel *)groupSyncRecordModelWithUniqueID:(NSString *)uniqueID syncRecordType:(PPSyncRecordType)syncRecordType error:(NSError **)error;
- (PPSyncRecordModel *)cardSyncRecordModelWithUniqueID:(NSString *)uniqueID syncRecordType:(PPSyncRecordType)syncRecordType error:(NSError **)error;
- (NSMutableArray *)groupSyncRecordModelsWithError:(NSError **)error;
- (NSMutableArray *)groupSyncRecordModelsOfLessThanVersion:(NSUInteger)version error:(NSError **)error;
- (NSMutableArray *)cardSyncRecordModelsWithError:(NSError **)error;
- (NSMutableArray *)cardSyncRecordModelsOfLessThanVersion:(NSUInteger)version error:(NSError **)error;

/// 轉換Local GroupID
///（WCM6.x把 "Starred in Android" 當作自訂群組，但實際上應該是系統群組。WCM7.0要修正這個問題需要用此函式調整local的groupID。）
- (BOOL)updateGroupSyncRecordWithOldLocalID:(NSString *)oldLocalID newLocalID:(NSString *)newLocalID error:(NSError **)error;

/// 變更group record中紀錄的修改時間
- (BOOL)updateGroupSyncRecordWithUniqueID:(NSString *)uniqueID modifiedTime:(NSDate *)modifiedTime syncRecordType:(PPSyncRecordType)syncRecordType error:(NSError **)error;

/// 變更card record中紀錄的修改時間
- (BOOL)updateCardSyncRecordWithUniqueID:(NSString *)uniqueID modifiedTime:(NSDate *)modifiedTime syncRecordType:(PPSyncRecordType)syncRecordType error:(NSError **)error;

@end
