//
//  PPSyncFieldModel.h
//  
//
//  Created by  Eddie on 2011/3/16.
//  Copyright 2011 Penpower. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface PPSyncFieldModel : NSObject <NSCopying>
{
@protected
	NSInteger       type_;
	NSInteger		subType_;
	id				value_;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic, assign) NSInteger		type;
@property (nonatomic, assign) NSInteger		subType;
@property (nonatomic, retain) id			value;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

- (void)setCombinedValueString:(NSString *)valueString withType:(NSInteger)combineType;
- (NSString *)combinedValueStringWithType:(NSInteger)combineType;
- (BOOL)hasCombinedValueWithType:(NSInteger)combineType;

@end
