//
//  PPStorageSpaceSelectViewControllerDelegate.h
//  Pods
//
//  Created by Howard on 2015/8/4.
//
//

#import <Foundation/Foundation.h>
#import "PPStorageSpaceSelectViewController+PublicParameterDefine.h"

@class PPStorageSpaceSelectViewController;

@protocol PPStorageSpaceSelectViewControllerDelegate <NSObject>

@required
- (void)storageSpaceSelectViewController:(PPStorageSpaceSelectViewController *)storageSpaceSelectViewController didStorageSpaceSelectControllerSpaceType:(PPStorageSpaceSelectControllerSpaceType)storageSpaceSelectControllerSpaceType;

- (void)storageSpaceSelectViewControllerDidCancel:(PPStorageSpaceSelectViewController *)storageSpaceSelectViewController;

@optional
/**
 * 回傳PPStorageSpaceSelectControllerSpaceType_Specific的顯示字串
 * @param storageSpaceSelectViewController storageSpaceSelectViewController
 * @return NSString 有指定cell時，顯示的字串，nil時會顯示MLS_StorageSpecificTitle
 */
- (NSString *)specificStringWithStorageSpaceSelectViewController:(PPStorageSpaceSelectViewController*)storageSpaceSelectViewController;

- (BOOL)storageSpaceSelectViewControllerShowAlertWithError:(NSError *)error;
- (NSString *)storageSpaceSelectViewControllerRequestErrorMessageWithError:(NSError *)error;

/**
 通知外部詢問空間是否登入
 處理方式:詢問空間是否登入
 
 @param storageSpaceSelectViewController 委託者
 @param spaceType                        空間
 
 @return YES 登入
 */
- (BOOL)storageSpaceSelectViewController:(PPStorageSpaceSelectViewController *)storageSpaceSelectViewController
                     isLinkWithSpaceType:(PPStorageSpaceSelectControllerSpaceType)spaceType;



/**
 通知外部進行登入空間
 處理方式:外部進行登入空間

 @param storageSpaceSelectViewController 委託者
 @param spaceType                        空間
 @param error                            回傳錯誤

 @return YES 登入成功
 */
- (BOOL)storageSpaceSelectViewController:(PPStorageSpaceSelectViewController *)storageSpaceSelectViewController
                    didlinkWithSpaceType:(PPStorageSpaceSelectControllerSpaceType)spaceType
                                   error:(NSError **)error;

/**
 通知外部進行登出空間
 處理方式:外部進行登出空間
 
 @param storageSpaceSelectViewController 委託者
 @param spaceType                        空間
 @param error                            回傳錯誤
 
 @return YES 登出成功
 */
- (BOOL)storageSpaceSelectViewController:(PPStorageSpaceSelectViewController *)storageSpaceSelectViewController
                  didUnlinkWithSpaceType:(PPStorageSpaceSelectControllerSpaceType)spaceType
                                   error:(NSError **)error;


/**
 通知外部進行帳號資訊讀取
 處理方式:外部進行帳號資訊讀取
 
 @param storageSpaceSelectViewController 委託者
 @param spaceType                        空間
 @param error                            回傳錯誤
 
 @return 帳號名稱
 */
- (NSString *)storageSpaceSelectViewController:(PPStorageSpaceSelectViewController *)storageSpaceSelectViewController
                      accountNameWithSpaceType:(PPStorageSpaceSelectControllerSpaceType)spaceType
                                         error:(NSError **)error;
@end
