//
//  PPImageEnhanceViewController.h
//
//  Created by Mike on 2011/7/4.
//  Copyright 2011年 Penpower. All rights reserved.
//

// Define
#import "PPAppearance.h"

// Controller
#import "PPViewController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, ImageEnhanceViewControllerAction)
{
    ImageEnhanceViewControllerAction_Done,
    ImageEnhanceViewControllerAction_Light,
    ImageEnhanceViewControllerAction_Clip
};


////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSInteger, ImageEnhanceViewControllerButtonTag)
{
    ImageEnhanceViewControllerButtonTag_Back = 1,
    ImageEnhanceViewControllerButtonTag_Cancel,
    ImageEnhanceViewControllerButtonTag_Done,
    ImageEnhanceViewControllerButtonTag_Light,
    ImageEnhanceViewControllerButtonTag_ImageRectification,
    ImageEnhanceViewControllerButtonTag_FullRect,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@class PPImageEnhanceViewController;
@protocol PPImageEnhanceViewControllerDelegate <NSObject>
/**
 * 通知AP, viewController的動作，並確認是否可以執行
 * @param imageEnhanceViewController view controller實體
 * @param action 目前執行的動作
 * @return BOOL YES:可以執行，NO: 不能執行
 */
- (BOOL)imageEnhanceViewController:(PPImageEnhanceViewController *)imageEnhanceViewController action:(ImageEnhanceViewControllerAction)action;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPImageEnhanceViewController : PPViewController
<
PPAppearance
>

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property(nonatomic,assign) id<PPImageEnhanceViewControllerDelegate>  delegate;
@property(nonatomic,retain) UIImage                                   *sourceImage;
@property(nonatomic,retain) UIColor                                   *buttonHighlightedBackgroundColor PP_APPEARANCE_SELECTOR;
@property(nonatomic,retain) UIColor                                   *bottomBarViewBackgroundColor PP_APPEARANCE_SELECTOR;
@property(nonatomic,retain) UIColor                                   *imageScrollCropViewBakcgroundColor PP_APPEARANCE_SELECTOR;
@property(nonatomic,assign) UIEdgeInsets                              buttonImageEdgeInsets PP_APPEARANCE_SELECTOR;

@end
