//
//  PPImageLuminance.h
//  PPCameraView
//
//  Created by sanhue cheng on 2020/5/15.
//

#import <Foundation/Foundation.h>
#import "LuminanceInfo.h"

NS_ASSUME_NONNULL_BEGIN

@interface PPImageAlignment : NSObject


/**
 * initialize a image luminance filter
 * @param device The device the filter will run on
 * @return A valid object or nil, if failure.
 */
- (nullable instancetype)initWithDevice:(nonnull id <MTLDevice>)device;


/**
 * alignment
 * @param commandBuffer commandBuffer to encode in
 * @param sourceTextures 三張圖片素材
 * @param imageSize 圖片的大小
 */
-(void)encodeToCommandBuffer:(nonnull id <MTLCommandBuffer>)commandBuffer
              sourceTextures:(nonnull NSArray <id <MTLTexture>>*)sourceTextures
                   imageSize:(CGSize)imageSize;

@end

NS_ASSUME_NONNULL_END
