///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMTokenGetAuthenticatedAdminError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `TokenGetAuthenticatedAdminError` union.
///
/// Error returned by `tokenGetAuthenticatedAdmin`.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMTokenGetAuthenticatedAdminError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMTokenGetAuthenticatedAdminErrorTag` enum type represents the
/// possible tag states with which the `DBTEAMTokenGetAuthenticatedAdminError`
/// union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMTokenGetAuthenticatedAdminErrorTag){
    /// The current token is not associated with a team admin, because mappings
    /// were not recorded when the token was created. Consider re-authorizing a
    /// new access token to record its authenticating admin.
    DBTEAMTokenGetAuthenticatedAdminErrorMappingNotFound,

    /// Either the team admin that authorized this token is no longer an active
    /// member of the team or no longer a team admin.
    DBTEAMTokenGetAuthenticatedAdminErrorAdminNotActive,

    /// (no description).
    DBTEAMTokenGetAuthenticatedAdminErrorOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMTokenGetAuthenticatedAdminErrorTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "mapping_not_found".
///
/// Description of the "mapping_not_found" tag state: The current token is not
/// associated with a team admin, because mappings were not recorded when the
/// token was created. Consider re-authorizing a new access token to record its
/// authenticating admin.
///
/// @return An initialized instance.
///
- (instancetype)initWithMappingNotFound;

///
/// Initializes union class with tag state of "admin_not_active".
///
/// Description of the "admin_not_active" tag state: Either the team admin that
/// authorized this token is no longer an active member of the team or no longer
/// a team admin.
///
/// @return An initialized instance.
///
- (instancetype)initWithAdminNotActive;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value
/// "mapping_not_found".
///
/// @return Whether the union's current tag state has value "mapping_not_found".
///
- (BOOL)isMappingNotFound;

///
/// Retrieves whether the union's current tag state has value
/// "admin_not_active".
///
/// @return Whether the union's current tag state has value "admin_not_active".
///
- (BOOL)isAdminNotActive;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMTokenGetAuthenticatedAdminError`
/// union.
///
@interface DBTEAMTokenGetAuthenticatedAdminErrorSerializer : NSObject

///
/// Serializes `DBTEAMTokenGetAuthenticatedAdminError` instances.
///
/// @param instance An instance of the `DBTEAMTokenGetAuthenticatedAdminError`
/// API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMTokenGetAuthenticatedAdminError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMTokenGetAuthenticatedAdminError *)instance;

///
/// Deserializes `DBTEAMTokenGetAuthenticatedAdminError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMTokenGetAuthenticatedAdminError` API object.
///
/// @return An instantiation of the `DBTEAMTokenGetAuthenticatedAdminError`
/// object.
///
+ (DBTEAMTokenGetAuthenticatedAdminError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
