///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMTeamFolderAccessError;
@class DBTEAMTeamFolderArchiveError;
@class DBTEAMTeamFolderInvalidStatusError;
@class DBTEAMTeamFolderTeamSharedDropboxError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `TeamFolderArchiveError` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMTeamFolderArchiveError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMTeamFolderArchiveErrorTag` enum type represents the possible tag
/// states with which the `DBTEAMTeamFolderArchiveError` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMTeamFolderArchiveErrorTag){
    /// (no description).
    DBTEAMTeamFolderArchiveErrorAccessError,

    /// (no description).
    DBTEAMTeamFolderArchiveErrorStatusError,

    /// (no description).
    DBTEAMTeamFolderArchiveErrorTeamSharedDropboxError,

    /// (no description).
    DBTEAMTeamFolderArchiveErrorOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMTeamFolderArchiveErrorTag tag;

/// (no description). @note Ensure the `isAccessError` method returns true
/// before accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBTEAMTeamFolderAccessError *accessError;

/// (no description). @note Ensure the `isStatusError` method returns true
/// before accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBTEAMTeamFolderInvalidStatusError *statusError;

/// (no description). @note Ensure the `isTeamSharedDropboxError` method returns
/// true before accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBTEAMTeamFolderTeamSharedDropboxError *teamSharedDropboxError;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "access_error".
///
/// @param accessError (no description).
///
/// @return An initialized instance.
///
- (instancetype)initWithAccessError:(DBTEAMTeamFolderAccessError *)accessError;

///
/// Initializes union class with tag state of "status_error".
///
/// @param statusError (no description).
///
/// @return An initialized instance.
///
- (instancetype)initWithStatusError:(DBTEAMTeamFolderInvalidStatusError *)statusError;

///
/// Initializes union class with tag state of "team_shared_dropbox_error".
///
/// @param teamSharedDropboxError (no description).
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamSharedDropboxError:(DBTEAMTeamFolderTeamSharedDropboxError *)teamSharedDropboxError;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "access_error".
///
/// @note Call this method and ensure it returns true before accessing the
/// `accessError` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "access_error".
///
- (BOOL)isAccessError;

///
/// Retrieves whether the union's current tag state has value "status_error".
///
/// @note Call this method and ensure it returns true before accessing the
/// `statusError` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "status_error".
///
- (BOOL)isStatusError;

///
/// Retrieves whether the union's current tag state has value
/// "team_shared_dropbox_error".
///
/// @note Call this method and ensure it returns true before accessing the
/// `teamSharedDropboxError` property, otherwise a runtime exception will be
/// thrown.
///
/// @return Whether the union's current tag state has value
/// "team_shared_dropbox_error".
///
- (BOOL)isTeamSharedDropboxError;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMTeamFolderArchiveError` union.
///
@interface DBTEAMTeamFolderArchiveErrorSerializer : NSObject

///
/// Serializes `DBTEAMTeamFolderArchiveError` instances.
///
/// @param instance An instance of the `DBTEAMTeamFolderArchiveError` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMTeamFolderArchiveError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMTeamFolderArchiveError *)instance;

///
/// Deserializes `DBTEAMTeamFolderArchiveError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMTeamFolderArchiveError` API object.
///
/// @return An instantiation of the `DBTEAMTeamFolderArchiveError` object.
///
+ (DBTEAMTeamFolderArchiveError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
