///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMPOLICIESGroupCreation;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `GroupCreation` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMPOLICIESGroupCreation : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMPOLICIESGroupCreationTag` enum type represents the possible tag
/// states with which the `DBTEAMPOLICIESGroupCreation` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMPOLICIESGroupCreationTag){
    /// Team admins and members can create groups.
    DBTEAMPOLICIESGroupCreationAdminsAndMembers,

    /// Only team admins can create groups.
    DBTEAMPOLICIESGroupCreationAdminsOnly,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMPOLICIESGroupCreationTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "admins_and_members".
///
/// Description of the "admins_and_members" tag state: Team admins and members
/// can create groups.
///
/// @return An initialized instance.
///
- (instancetype)initWithAdminsAndMembers;

///
/// Initializes union class with tag state of "admins_only".
///
/// Description of the "admins_only" tag state: Only team admins can create
/// groups.
///
/// @return An initialized instance.
///
- (instancetype)initWithAdminsOnly;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value
/// "admins_and_members".
///
/// @return Whether the union's current tag state has value
/// "admins_and_members".
///
- (BOOL)isAdminsAndMembers;

///
/// Retrieves whether the union's current tag state has value "admins_only".
///
/// @return Whether the union's current tag state has value "admins_only".
///
- (BOOL)isAdminsOnly;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMPOLICIESGroupCreation` union.
///
@interface DBTEAMPOLICIESGroupCreationSerializer : NSObject

///
/// Serializes `DBTEAMPOLICIESGroupCreation` instances.
///
/// @param instance An instance of the `DBTEAMPOLICIESGroupCreation` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMPOLICIESGroupCreation` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMPOLICIESGroupCreation *)instance;

///
/// Deserializes `DBTEAMPOLICIESGroupCreation` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMPOLICIESGroupCreation` API object.
///
/// @return An instantiation of the `DBTEAMPOLICIESGroupCreation` object.
///
+ (DBTEAMPOLICIESGroupCreation *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
