///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMPOLICIESEmmState;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `EmmState` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMPOLICIESEmmState : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMPOLICIESEmmStateTag` enum type represents the possible tag states
/// with which the `DBTEAMPOLICIESEmmState` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMPOLICIESEmmStateTag){
    /// Emm token is disabled.
    DBTEAMPOLICIESEmmStateDisabled,

    /// Emm token is optional.
    DBTEAMPOLICIESEmmStateOptional,

    /// Emm token is required.
    DBTEAMPOLICIESEmmStateRequired,

    /// (no description).
    DBTEAMPOLICIESEmmStateOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMPOLICIESEmmStateTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "disabled".
///
/// Description of the "disabled" tag state: Emm token is disabled.
///
/// @return An initialized instance.
///
- (instancetype)initWithDisabled;

///
/// Initializes union class with tag state of "optional".
///
/// Description of the "optional" tag state: Emm token is optional.
///
/// @return An initialized instance.
///
- (instancetype)initWithOptional;

///
/// Initializes union class with tag state of "required".
///
/// Description of the "required" tag state: Emm token is required.
///
/// @return An initialized instance.
///
- (instancetype)initWithRequired;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "disabled".
///
/// @return Whether the union's current tag state has value "disabled".
///
- (BOOL)isDisabled;

///
/// Retrieves whether the union's current tag state has value "optional".
///
/// @return Whether the union's current tag state has value "optional".
///
- (BOOL)isOptional;

///
/// Retrieves whether the union's current tag state has value "required".
///
/// @return Whether the union's current tag state has value "required".
///
- (BOOL)isRequired;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMPOLICIESEmmState` union.
///
@interface DBTEAMPOLICIESEmmStateSerializer : NSObject

///
/// Serializes `DBTEAMPOLICIESEmmState` instances.
///
/// @param instance An instance of the `DBTEAMPOLICIESEmmState` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMPOLICIESEmmState` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMPOLICIESEmmState *)instance;

///
/// Deserializes `DBTEAMPOLICIESEmmState` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMPOLICIESEmmState` API object.
///
/// @return An instantiation of the `DBTEAMPOLICIESEmmState` object.
///
+ (DBTEAMPOLICIESEmmState *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
