///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"
#import "DBTEAMMembersDeactivateArg.h"

@class DBTEAMMembersRemoveArg;
@class DBTEAMUserSelectorArg;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `MembersRemoveArg` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMMembersRemoveArg : DBTEAMMembersDeactivateArg <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// If provided, files from the deleted member account will be transferred to
/// this user.
@property (nonatomic, readonly, nullable) DBTEAMUserSelectorArg *transferDestId;

/// If provided, errors during the transfer process will be sent via email to
/// this user. If the transfer_dest_id argument was provided, then this argument
/// must be provided as well.
@property (nonatomic, readonly, nullable) DBTEAMUserSelectorArg *transferAdminId;

/// Downgrade the member to a Basic account. The user will retain the email
/// address associated with their Dropbox  account and data in their account
/// that is not restricted to team members. In order to keep the account the
/// argument wipeData should be set to false.
@property (nonatomic, readonly) NSNumber *keepAccount;

/// If provided, allows removed users to keep access to Dropbox folders (not
/// Dropbox Paper folders) already explicitly shared with them (not via a group)
/// when they are downgraded to a Basic account. Users will not retain access to
/// folders that do not allow external sharing. In order to keep the sharing
/// relationships, the arguments wipeData should be set to false and keepAccount
/// should be set to true.
@property (nonatomic, readonly) NSNumber *retainTeamShares;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param user Identity of user to remove/suspend/have their files moved.
/// @param wipeData If provided, controls if the user's data will be deleted on
/// their linked devices.
/// @param transferDestId If provided, files from the deleted member account
/// will be transferred to this user.
/// @param transferAdminId If provided, errors during the transfer process will
/// be sent via email to this user. If the transfer_dest_id argument was
/// provided, then this argument must be provided as well.
/// @param keepAccount Downgrade the member to a Basic account. The user will
/// retain the email address associated with their Dropbox  account and data in
/// their account that is not restricted to team members. In order to keep the
/// account the argument wipeData should be set to false.
/// @param retainTeamShares If provided, allows removed users to keep access to
/// Dropbox folders (not Dropbox Paper folders) already explicitly shared with
/// them (not via a group) when they are downgraded to a Basic account. Users
/// will not retain access to folders that do not allow external sharing. In
/// order to keep the sharing relationships, the arguments wipeData should be
/// set to false and keepAccount should be set to true.
///
/// @return An initialized instance.
///
- (instancetype)initWithUser:(DBTEAMUserSelectorArg *)user
                    wipeData:(nullable NSNumber *)wipeData
              transferDestId:(nullable DBTEAMUserSelectorArg *)transferDestId
             transferAdminId:(nullable DBTEAMUserSelectorArg *)transferAdminId
                 keepAccount:(nullable NSNumber *)keepAccount
            retainTeamShares:(nullable NSNumber *)retainTeamShares;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param user Identity of user to remove/suspend/have their files moved.
///
/// @return An initialized instance.
///
- (instancetype)initWithUser:(DBTEAMUserSelectorArg *)user;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `MembersRemoveArg` struct.
///
@interface DBTEAMMembersRemoveArgSerializer : NSObject

///
/// Serializes `DBTEAMMembersRemoveArg` instances.
///
/// @param instance An instance of the `DBTEAMMembersRemoveArg` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMMembersRemoveArg` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersRemoveArg *)instance;

///
/// Deserializes `DBTEAMMembersRemoveArg` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMMembersRemoveArg` API object.
///
/// @return An instantiation of the `DBTEAMMembersRemoveArg` object.
///
+ (DBTEAMMembersRemoveArg *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
