///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMMemberAddArg;
@class DBTEAMMembersAddArg;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `MembersAddArg` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMMembersAddArg : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Details of new members to be added to the team.
@property (nonatomic, readonly) NSArray<DBTEAMMemberAddArg *> *dNewMembers;

/// Whether to force the add to happen asynchronously.
@property (nonatomic, readonly) NSNumber *forceAsync;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param dNewMembers Details of new members to be added to the team.
/// @param forceAsync Whether to force the add to happen asynchronously.
///
/// @return An initialized instance.
///
- (instancetype)initWithDNewMembers:(NSArray<DBTEAMMemberAddArg *> *)dNewMembers
                         forceAsync:(nullable NSNumber *)forceAsync;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param dNewMembers Details of new members to be added to the team.
///
/// @return An initialized instance.
///
- (instancetype)initWithDNewMembers:(NSArray<DBTEAMMemberAddArg *> *)dNewMembers;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `MembersAddArg` struct.
///
@interface DBTEAMMembersAddArgSerializer : NSObject

///
/// Serializes `DBTEAMMembersAddArg` instances.
///
/// @param instance An instance of the `DBTEAMMembersAddArg` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMMembersAddArg` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersAddArg *)instance;

///
/// Deserializes `DBTEAMMembersAddArg` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMMembersAddArg` API object.
///
/// @return An instantiation of the `DBTEAMMembersAddArg` object.
///
+ (DBTEAMMembersAddArg *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
