///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGTeamFolderRenameDetails;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `TeamFolderRenameDetails` struct.
///
/// Renamed active/archived team folder.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGTeamFolderRenameDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Previous folder name.
@property (nonatomic, readonly, copy) NSString *previousFolderName;

/// New folder name.
@property (nonatomic, readonly, copy) NSString *dNewFolderName;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param previousFolderName Previous folder name.
/// @param dNewFolderName New folder name.
///
/// @return An initialized instance.
///
- (instancetype)initWithPreviousFolderName:(NSString *)previousFolderName dNewFolderName:(NSString *)dNewFolderName;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `TeamFolderRenameDetails` struct.
///
@interface DBTEAMLOGTeamFolderRenameDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGTeamFolderRenameDetails` instances.
///
/// @param instance An instance of the `DBTEAMLOGTeamFolderRenameDetails` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGTeamFolderRenameDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGTeamFolderRenameDetails *)instance;

///
/// Deserializes `DBTEAMLOGTeamFolderRenameDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGTeamFolderRenameDetails` API object.
///
/// @return An instantiation of the `DBTEAMLOGTeamFolderRenameDetails` object.
///
+ (DBTEAMLOGTeamFolderRenameDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
