///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGSharedLinkChangeVisibilityDetails;
@class DBTEAMLOGSharedLinkVisibility;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `SharedLinkChangeVisibilityDetails` struct.
///
/// Changed visibility of shared link.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGSharedLinkChangeVisibilityDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// New shared link visibility.
@property (nonatomic, readonly) DBTEAMLOGSharedLinkVisibility *dNewValue;

/// Previous shared link visibility. Might be missing due to historical data
/// gap.
@property (nonatomic, readonly, nullable) DBTEAMLOGSharedLinkVisibility *previousValue;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param dNewValue New shared link visibility.
/// @param previousValue Previous shared link visibility. Might be missing due
/// to historical data gap.
///
/// @return An initialized instance.
///
- (instancetype)initWithDNewValue:(DBTEAMLOGSharedLinkVisibility *)dNewValue
                    previousValue:(nullable DBTEAMLOGSharedLinkVisibility *)previousValue;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param dNewValue New shared link visibility.
///
/// @return An initialized instance.
///
- (instancetype)initWithDNewValue:(DBTEAMLOGSharedLinkVisibility *)dNewValue;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `SharedLinkChangeVisibilityDetails` struct.
///
@interface DBTEAMLOGSharedLinkChangeVisibilityDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGSharedLinkChangeVisibilityDetails` instances.
///
/// @param instance An instance of the
/// `DBTEAMLOGSharedLinkChangeVisibilityDetails` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGSharedLinkChangeVisibilityDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGSharedLinkChangeVisibilityDetails *)instance;

///
/// Deserializes `DBTEAMLOGSharedLinkChangeVisibilityDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGSharedLinkChangeVisibilityDetails` API object.
///
/// @return An instantiation of the `DBTEAMLOGSharedLinkChangeVisibilityDetails`
/// object.
///
+ (DBTEAMLOGSharedLinkChangeVisibilityDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
