///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGPaperContentAddToFolderDetails;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `PaperContentAddToFolderDetails` struct.
///
/// Added Paper doc/folder to folder.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGPaperContentAddToFolderDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Event unique identifier.
@property (nonatomic, readonly, copy) NSString *eventUuid;

/// Target asset position in the Assets list.
@property (nonatomic, readonly) NSNumber *targetAssetIndex;

/// Parent asset position in the Assets list.
@property (nonatomic, readonly) NSNumber *parentAssetIndex;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param eventUuid Event unique identifier.
/// @param targetAssetIndex Target asset position in the Assets list.
/// @param parentAssetIndex Parent asset position in the Assets list.
///
/// @return An initialized instance.
///
- (instancetype)initWithEventUuid:(NSString *)eventUuid
                 targetAssetIndex:(NSNumber *)targetAssetIndex
                 parentAssetIndex:(NSNumber *)parentAssetIndex;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `PaperContentAddToFolderDetails` struct.
///
@interface DBTEAMLOGPaperContentAddToFolderDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGPaperContentAddToFolderDetails` instances.
///
/// @param instance An instance of the `DBTEAMLOGPaperContentAddToFolderDetails`
/// API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGPaperContentAddToFolderDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGPaperContentAddToFolderDetails *)instance;

///
/// Deserializes `DBTEAMLOGPaperContentAddToFolderDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGPaperContentAddToFolderDetails` API object.
///
/// @return An instantiation of the `DBTEAMLOGPaperContentAddToFolderDetails`
/// object.
///
+ (DBTEAMLOGPaperContentAddToFolderDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
