///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGLabelType;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `LabelType` union.
///
/// Label type
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGLabelType : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMLOGLabelTypeTag` enum type represents the possible tag states
/// with which the `DBTEAMLOGLabelType` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMLOGLabelTypeTag){
    /// (no description).
    DBTEAMLOGLabelTypePersonalInformation,

    /// (no description).
    DBTEAMLOGLabelTypeOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMLOGLabelTypeTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "personal_information".
///
/// @return An initialized instance.
///
- (instancetype)initWithPersonalInformation;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value
/// "personal_information".
///
/// @return Whether the union's current tag state has value
/// "personal_information".
///
- (BOOL)isPersonalInformation;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMLOGLabelType` union.
///
@interface DBTEAMLOGLabelTypeSerializer : NSObject

///
/// Serializes `DBTEAMLOGLabelType` instances.
///
/// @param instance An instance of the `DBTEAMLOGLabelType` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGLabelType` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGLabelType *)instance;

///
/// Deserializes `DBTEAMLOGLabelType` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGLabelType` API object.
///
/// @return An instantiation of the `DBTEAMLOGLabelType` object.
///
+ (DBTEAMLOGLabelType *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
