///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGGuestAdminSignedInViaTrustedTeamsDetails;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `GuestAdminSignedInViaTrustedTeamsDetails` struct.
///
/// Started trusted team admin session.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGGuestAdminSignedInViaTrustedTeamsDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Host team name.
@property (nonatomic, readonly, copy, nullable) NSString *teamName;

/// Trusted team name.
@property (nonatomic, readonly, copy, nullable) NSString *trustedTeamName;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param teamName Host team name.
/// @param trustedTeamName Trusted team name.
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamName:(nullable NSString *)teamName trustedTeamName:(nullable NSString *)trustedTeamName;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
///
/// @return An initialized instance.
///
- (instancetype)initDefault;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `GuestAdminSignedInViaTrustedTeamsDetails`
/// struct.
///
@interface DBTEAMLOGGuestAdminSignedInViaTrustedTeamsDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGGuestAdminSignedInViaTrustedTeamsDetails` instances.
///
/// @param instance An instance of the
/// `DBTEAMLOGGuestAdminSignedInViaTrustedTeamsDetails` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGGuestAdminSignedInViaTrustedTeamsDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGGuestAdminSignedInViaTrustedTeamsDetails *)instance;

///
/// Deserializes `DBTEAMLOGGuestAdminSignedInViaTrustedTeamsDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGGuestAdminSignedInViaTrustedTeamsDetails` API object.
///
/// @return An instantiation of the
/// `DBTEAMLOGGuestAdminSignedInViaTrustedTeamsDetails` object.
///
+ (DBTEAMLOGGuestAdminSignedInViaTrustedTeamsDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
