///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGDeviceDeleteOnUnlinkSuccessDetails;
@class DBTEAMLOGSessionLogInfo;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `DeviceDeleteOnUnlinkSuccessDetails` struct.
///
/// Deleted all files from unlinked device.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGDeviceDeleteOnUnlinkSuccessDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Session unique id.
@property (nonatomic, readonly, nullable) DBTEAMLOGSessionLogInfo *sessionInfo;

/// The device name. Might be missing due to historical data gap.
@property (nonatomic, readonly, copy, nullable) NSString *displayName;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param sessionInfo Session unique id.
/// @param displayName The device name. Might be missing due to historical data
/// gap.
///
/// @return An initialized instance.
///
- (instancetype)initWithSessionInfo:(nullable DBTEAMLOGSessionLogInfo *)sessionInfo
                        displayName:(nullable NSString *)displayName;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
///
/// @return An initialized instance.
///
- (instancetype)initDefault;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DeviceDeleteOnUnlinkSuccessDetails` struct.
///
@interface DBTEAMLOGDeviceDeleteOnUnlinkSuccessDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGDeviceDeleteOnUnlinkSuccessDetails` instances.
///
/// @param instance An instance of the
/// `DBTEAMLOGDeviceDeleteOnUnlinkSuccessDetails` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGDeviceDeleteOnUnlinkSuccessDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceDeleteOnUnlinkSuccessDetails *)instance;

///
/// Deserializes `DBTEAMLOGDeviceDeleteOnUnlinkSuccessDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGDeviceDeleteOnUnlinkSuccessDetails` API object.
///
/// @return An instantiation of the
/// `DBTEAMLOGDeviceDeleteOnUnlinkSuccessDetails` object.
///
+ (DBTEAMLOGDeviceDeleteOnUnlinkSuccessDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
