///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGClassificationType;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `ClassificationType` union.
///
/// The type of classification (currently only personal information)
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGClassificationType : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMLOGClassificationTypeTag` enum type represents the possible tag
/// states with which the `DBTEAMLOGClassificationType` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMLOGClassificationTypeTag){
    /// (no description).
    DBTEAMLOGClassificationTypePersonalInformation,

    /// (no description).
    DBTEAMLOGClassificationTypePii,

    /// (no description).
    DBTEAMLOGClassificationTypeOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMLOGClassificationTypeTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "personal_information".
///
/// @return An initialized instance.
///
- (instancetype)initWithPersonalInformation;

///
/// Initializes union class with tag state of "pii".
///
/// @return An initialized instance.
///
- (instancetype)initWithPii;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value
/// "personal_information".
///
/// @return Whether the union's current tag state has value
/// "personal_information".
///
- (BOOL)isPersonalInformation;

///
/// Retrieves whether the union's current tag state has value "pii".
///
/// @return Whether the union's current tag state has value "pii".
///
- (BOOL)isPii;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMLOGClassificationType` union.
///
@interface DBTEAMLOGClassificationTypeSerializer : NSObject

///
/// Serializes `DBTEAMLOGClassificationType` instances.
///
/// @param instance An instance of the `DBTEAMLOGClassificationType` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGClassificationType` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGClassificationType *)instance;

///
/// Deserializes `DBTEAMLOGClassificationType` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGClassificationType` API object.
///
/// @return An instantiation of the `DBTEAMLOGClassificationType` object.
///
+ (DBTEAMLOGClassificationType *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
