///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGAssetLogInfo;
@class DBTEAMLOGFileLogInfo;
@class DBTEAMLOGFolderLogInfo;
@class DBTEAMLOGPaperDocumentLogInfo;
@class DBTEAMLOGPaperFolderLogInfo;
@class DBTEAMLOGShowcaseDocumentLogInfo;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `AssetLogInfo` union.
///
/// Asset details.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGAssetLogInfo : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMLOGAssetLogInfoTag` enum type represents the possible tag states
/// with which the `DBTEAMLOGAssetLogInfo` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMLOGAssetLogInfoTag){
    /// File's details.
    DBTEAMLOGAssetLogInfoFile,

    /// Folder's details.
    DBTEAMLOGAssetLogInfoFolder,

    /// Paper document's details.
    DBTEAMLOGAssetLogInfoPaperDocument,

    /// Paper folder's details.
    DBTEAMLOGAssetLogInfoPaperFolder,

    /// Showcase document's details.
    DBTEAMLOGAssetLogInfoShowcaseDocument,

    /// (no description).
    DBTEAMLOGAssetLogInfoOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMLOGAssetLogInfoTag tag;

/// File's details. @note Ensure the `isFile` method returns true before
/// accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBTEAMLOGFileLogInfo *file;

/// Folder's details. @note Ensure the `isFolder` method returns true before
/// accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBTEAMLOGFolderLogInfo *folder;

/// Paper document's details. @note Ensure the `isPaperDocument` method returns
/// true before accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBTEAMLOGPaperDocumentLogInfo *paperDocument;

/// Paper folder's details. @note Ensure the `isPaperFolder` method returns true
/// before accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBTEAMLOGPaperFolderLogInfo *paperFolder;

/// Showcase document's details. @note Ensure the `isShowcaseDocument` method
/// returns true before accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBTEAMLOGShowcaseDocumentLogInfo *showcaseDocument;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "file".
///
/// Description of the "file" tag state: File's details.
///
/// @param file File's details.
///
/// @return An initialized instance.
///
- (instancetype)initWithFile:(DBTEAMLOGFileLogInfo *)file;

///
/// Initializes union class with tag state of "folder".
///
/// Description of the "folder" tag state: Folder's details.
///
/// @param folder Folder's details.
///
/// @return An initialized instance.
///
- (instancetype)initWithFolder:(DBTEAMLOGFolderLogInfo *)folder;

///
/// Initializes union class with tag state of "paper_document".
///
/// Description of the "paper_document" tag state: Paper document's details.
///
/// @param paperDocument Paper document's details.
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperDocument:(DBTEAMLOGPaperDocumentLogInfo *)paperDocument;

///
/// Initializes union class with tag state of "paper_folder".
///
/// Description of the "paper_folder" tag state: Paper folder's details.
///
/// @param paperFolder Paper folder's details.
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperFolder:(DBTEAMLOGPaperFolderLogInfo *)paperFolder;

///
/// Initializes union class with tag state of "showcase_document".
///
/// Description of the "showcase_document" tag state: Showcase document's
/// details.
///
/// @param showcaseDocument Showcase document's details.
///
/// @return An initialized instance.
///
- (instancetype)initWithShowcaseDocument:(DBTEAMLOGShowcaseDocumentLogInfo *)showcaseDocument;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "file".
///
/// @note Call this method and ensure it returns true before accessing the
/// `file` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "file".
///
- (BOOL)isFile;

///
/// Retrieves whether the union's current tag state has value "folder".
///
/// @note Call this method and ensure it returns true before accessing the
/// `folder` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "folder".
///
- (BOOL)isFolder;

///
/// Retrieves whether the union's current tag state has value "paper_document".
///
/// @note Call this method and ensure it returns true before accessing the
/// `paperDocument` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "paper_document".
///
- (BOOL)isPaperDocument;

///
/// Retrieves whether the union's current tag state has value "paper_folder".
///
/// @note Call this method and ensure it returns true before accessing the
/// `paperFolder` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "paper_folder".
///
- (BOOL)isPaperFolder;

///
/// Retrieves whether the union's current tag state has value
/// "showcase_document".
///
/// @note Call this method and ensure it returns true before accessing the
/// `showcaseDocument` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "showcase_document".
///
- (BOOL)isShowcaseDocument;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMLOGAssetLogInfo` union.
///
@interface DBTEAMLOGAssetLogInfoSerializer : NSObject

///
/// Serializes `DBTEAMLOGAssetLogInfo` instances.
///
/// @param instance An instance of the `DBTEAMLOGAssetLogInfo` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGAssetLogInfo` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAssetLogInfo *)instance;

///
/// Deserializes `DBTEAMLOGAssetLogInfo` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGAssetLogInfo` API object.
///
/// @return An instantiation of the `DBTEAMLOGAssetLogInfo` object.
///
+ (DBTEAMLOGAssetLogInfo *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
