///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSHARINGShareFolderArgBase.h"
#import "DBSerializableProtocol.h"

@class DBSHARINGAccessInheritance;
@class DBSHARINGAclUpdatePolicy;
@class DBSHARINGFolderAction;
@class DBSHARINGLinkSettings;
@class DBSHARINGMemberPolicy;
@class DBSHARINGShareFolderArg;
@class DBSHARINGSharedLinkPolicy;
@class DBSHARINGViewerInfoPolicy;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `ShareFolderArg` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBSHARINGShareFolderArg : DBSHARINGShareFolderArgBase <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// A list of `FolderAction`s corresponding to `FolderPermission`s that should
/// appear in the  response's `permissions` in `DBSHARINGSharedFolderMetadata`
/// field describing the actions the  authenticated user can perform on the
/// folder.
@property (nonatomic, readonly, nullable) NSArray<DBSHARINGFolderAction *> *actions;

/// Settings on the link for this folder.
@property (nonatomic, readonly, nullable) DBSHARINGLinkSettings *linkSettings;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param path The path to the folder to share. If it does not exist, then a
/// new one is created.
/// @param aclUpdatePolicy Who can add and remove members of this shared folder.
/// @param forceAsync Whether to force the share to happen asynchronously.
/// @param memberPolicy Who can be a member of this shared folder. Only
/// applicable if the current user is on a team.
/// @param sharedLinkPolicy The policy to apply to shared links created for
/// content inside this shared folder.  The current user must be on a team to
/// set this policy to `members` in `DBSHARINGSharedLinkPolicy`.
/// @param viewerInfoPolicy Who can enable/disable viewer info for this shared
/// folder.
/// @param accessInheritance The access inheritance settings for the folder.
/// @param actions A list of `FolderAction`s corresponding to
/// `FolderPermission`s that should appear in the  response's `permissions` in
/// `DBSHARINGSharedFolderMetadata` field describing the actions the
/// authenticated user can perform on the folder.
/// @param linkSettings Settings on the link for this folder.
///
/// @return An initialized instance.
///
- (instancetype)initWithPath:(NSString *)path
             aclUpdatePolicy:(nullable DBSHARINGAclUpdatePolicy *)aclUpdatePolicy
                  forceAsync:(nullable NSNumber *)forceAsync
                memberPolicy:(nullable DBSHARINGMemberPolicy *)memberPolicy
            sharedLinkPolicy:(nullable DBSHARINGSharedLinkPolicy *)sharedLinkPolicy
            viewerInfoPolicy:(nullable DBSHARINGViewerInfoPolicy *)viewerInfoPolicy
           accessInheritance:(nullable DBSHARINGAccessInheritance *)accessInheritance
                     actions:(nullable NSArray<DBSHARINGFolderAction *> *)actions
                linkSettings:(nullable DBSHARINGLinkSettings *)linkSettings;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param path The path to the folder to share. If it does not exist, then a
/// new one is created.
///
/// @return An initialized instance.
///
- (instancetype)initWithPath:(NSString *)path;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `ShareFolderArg` struct.
///
@interface DBSHARINGShareFolderArgSerializer : NSObject

///
/// Serializes `DBSHARINGShareFolderArg` instances.
///
/// @param instance An instance of the `DBSHARINGShareFolderArg` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBSHARINGShareFolderArg` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBSHARINGShareFolderArg *)instance;

///
/// Deserializes `DBSHARINGShareFolderArg` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBSHARINGShareFolderArg` API object.
///
/// @return An instantiation of the `DBSHARINGShareFolderArg` object.
///
+ (DBSHARINGShareFolderArg *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
