///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBSHARINGInsufficientQuotaAmounts;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `InsufficientQuotaAmounts` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBSHARINGInsufficientQuotaAmounts : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The amount of space needed to add the item (the size of the item).
@property (nonatomic, readonly) NSNumber *spaceNeeded;

/// The amount of extra space needed to add the item.
@property (nonatomic, readonly) NSNumber *spaceShortage;

/// The amount of space left in the user's Dropbox, less than space_needed.
@property (nonatomic, readonly) NSNumber *spaceLeft;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param spaceNeeded The amount of space needed to add the item (the size of
/// the item).
/// @param spaceShortage The amount of extra space needed to add the item.
/// @param spaceLeft The amount of space left in the user's Dropbox, less than
/// space_needed.
///
/// @return An initialized instance.
///
- (instancetype)initWithSpaceNeeded:(NSNumber *)spaceNeeded
                      spaceShortage:(NSNumber *)spaceShortage
                          spaceLeft:(NSNumber *)spaceLeft;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `InsufficientQuotaAmounts` struct.
///
@interface DBSHARINGInsufficientQuotaAmountsSerializer : NSObject

///
/// Serializes `DBSHARINGInsufficientQuotaAmounts` instances.
///
/// @param instance An instance of the `DBSHARINGInsufficientQuotaAmounts` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBSHARINGInsufficientQuotaAmounts` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBSHARINGInsufficientQuotaAmounts *)instance;

///
/// Deserializes `DBSHARINGInsufficientQuotaAmounts` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBSHARINGInsufficientQuotaAmounts` API object.
///
/// @return An instantiation of the `DBSHARINGInsufficientQuotaAmounts` object.
///
+ (DBSHARINGInsufficientQuotaAmounts *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
