///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESUploadSessionType;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `UploadSessionType` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESUploadSessionType : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBFILESUploadSessionTypeTag` enum type represents the possible tag
/// states with which the `DBFILESUploadSessionType` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBFILESUploadSessionTypeTag){
    /// Pieces of data are uploaded sequentially one after another. This is the
    /// default behavior.
    DBFILESUploadSessionTypeSequential,

    /// Pieces of data can be uploaded in concurrent RPCs in any order.
    DBFILESUploadSessionTypeConcurrent,

    /// (no description).
    DBFILESUploadSessionTypeOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBFILESUploadSessionTypeTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "sequential".
///
/// Description of the "sequential" tag state: Pieces of data are uploaded
/// sequentially one after another. This is the default behavior.
///
/// @return An initialized instance.
///
- (instancetype)initWithSequential;

///
/// Initializes union class with tag state of "concurrent".
///
/// Description of the "concurrent" tag state: Pieces of data can be uploaded in
/// concurrent RPCs in any order.
///
/// @return An initialized instance.
///
- (instancetype)initWithConcurrent;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "sequential".
///
/// @return Whether the union's current tag state has value "sequential".
///
- (BOOL)isSequential;

///
/// Retrieves whether the union's current tag state has value "concurrent".
///
/// @return Whether the union's current tag state has value "concurrent".
///
- (BOOL)isConcurrent;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBFILESUploadSessionType` union.
///
@interface DBFILESUploadSessionTypeSerializer : NSObject

///
/// Serializes `DBFILESUploadSessionType` instances.
///
/// @param instance An instance of the `DBFILESUploadSessionType` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESUploadSessionType` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESUploadSessionType *)instance;

///
/// Deserializes `DBFILESUploadSessionType` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESUploadSessionType` API object.
///
/// @return An instantiation of the `DBFILESUploadSessionType` object.
///
+ (DBFILESUploadSessionType *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
