///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESLookupError;
@class DBFILESSyncSettingsError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `SyncSettingsError` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESSyncSettingsError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBFILESSyncSettingsErrorTag` enum type represents the possible tag
/// states with which the `DBFILESSyncSettingsError` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBFILESSyncSettingsErrorTag){
    /// (no description).
    DBFILESSyncSettingsErrorPath,

    /// Setting this combination of sync settings simultaneously is not
    /// supported.
    DBFILESSyncSettingsErrorUnsupportedCombination,

    /// The specified configuration is not supported.
    DBFILESSyncSettingsErrorUnsupportedConfiguration,

    /// (no description).
    DBFILESSyncSettingsErrorOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBFILESSyncSettingsErrorTag tag;

/// (no description). @note Ensure the `isPath` method returns true before
/// accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBFILESLookupError *path;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "path".
///
/// @param path (no description).
///
/// @return An initialized instance.
///
- (instancetype)initWithPath:(DBFILESLookupError *)path;

///
/// Initializes union class with tag state of "unsupported_combination".
///
/// Description of the "unsupported_combination" tag state: Setting this
/// combination of sync settings simultaneously is not supported.
///
/// @return An initialized instance.
///
- (instancetype)initWithUnsupportedCombination;

///
/// Initializes union class with tag state of "unsupported_configuration".
///
/// Description of the "unsupported_configuration" tag state: The specified
/// configuration is not supported.
///
/// @return An initialized instance.
///
- (instancetype)initWithUnsupportedConfiguration;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "path".
///
/// @note Call this method and ensure it returns true before accessing the
/// `path` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "path".
///
- (BOOL)isPath;

///
/// Retrieves whether the union's current tag state has value
/// "unsupported_combination".
///
/// @return Whether the union's current tag state has value
/// "unsupported_combination".
///
- (BOOL)isUnsupportedCombination;

///
/// Retrieves whether the union's current tag state has value
/// "unsupported_configuration".
///
/// @return Whether the union's current tag state has value
/// "unsupported_configuration".
///
- (BOOL)isUnsupportedConfiguration;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBFILESSyncSettingsError` union.
///
@interface DBFILESSyncSettingsErrorSerializer : NSObject

///
/// Serializes `DBFILESSyncSettingsError` instances.
///
/// @param instance An instance of the `DBFILESSyncSettingsError` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESSyncSettingsError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESSyncSettingsError *)instance;

///
/// Deserializes `DBFILESSyncSettingsError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESSyncSettingsError` API object.
///
/// @return An instantiation of the `DBFILESSyncSettingsError` object.
///
+ (DBFILESSyncSettingsError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
