///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESSaveCopyReferenceArg;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `SaveCopyReferenceArg` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESSaveCopyReferenceArg : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// A copy reference returned by `dCopyReferenceGet`.
@property (nonatomic, readonly, copy) NSString *dCopyReference;

/// Path in the user's Dropbox that is the destination.
@property (nonatomic, readonly, copy) NSString *path;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param dCopyReference A copy reference returned by `dCopyReferenceGet`.
/// @param path Path in the user's Dropbox that is the destination.
///
/// @return An initialized instance.
///
- (instancetype)initWithDCopyReference:(NSString *)dCopyReference path:(NSString *)path;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `SaveCopyReferenceArg` struct.
///
@interface DBFILESSaveCopyReferenceArgSerializer : NSObject

///
/// Serializes `DBFILESSaveCopyReferenceArg` instances.
///
/// @param instance An instance of the `DBFILESSaveCopyReferenceArg` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESSaveCopyReferenceArg` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESSaveCopyReferenceArg *)instance;

///
/// Deserializes `DBFILESSaveCopyReferenceArg` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESSaveCopyReferenceArg` API object.
///
/// @return An instantiation of the `DBFILESSaveCopyReferenceArg` object.
///
+ (DBFILESSaveCopyReferenceArg *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
