///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESPaperCreateError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `PaperCreateError` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESPaperCreateError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBFILESPaperCreateErrorTag` enum type represents the possible tag
/// states with which the `DBFILESPaperCreateError` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBFILESPaperCreateErrorTag){
    /// Your account does not have permissions to edit Paper docs.
    DBFILESPaperCreateErrorInsufficientPermissions,

    /// The provided content was malformed and cannot be imported to Paper.
    DBFILESPaperCreateErrorContentMalformed,

    /// The Paper doc would be too large, split the content into multiple docs.
    DBFILESPaperCreateErrorDocLengthExceeded,

    /// The imported document contains an image that is too large. The current
    /// limit is 1MB. This only applies to HTML with data URI.
    DBFILESPaperCreateErrorImageSizeExceeded,

    /// (no description).
    DBFILESPaperCreateErrorOther,

    /// The file could not be saved to the specified location.
    DBFILESPaperCreateErrorInvalidPath,

    /// The user's email must be verified to create Paper docs.
    DBFILESPaperCreateErrorEmailUnverified,

    /// The file path must end in .paper.
    DBFILESPaperCreateErrorInvalidFileExtension,

    /// Paper is disabled for your team.
    DBFILESPaperCreateErrorPaperDisabled,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBFILESPaperCreateErrorTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "insufficient_permissions".
///
/// Description of the "insufficient_permissions" tag state: Your account does
/// not have permissions to edit Paper docs.
///
/// @return An initialized instance.
///
- (instancetype)initWithInsufficientPermissions;

///
/// Initializes union class with tag state of "content_malformed".
///
/// Description of the "content_malformed" tag state: The provided content was
/// malformed and cannot be imported to Paper.
///
/// @return An initialized instance.
///
- (instancetype)initWithContentMalformed;

///
/// Initializes union class with tag state of "doc_length_exceeded".
///
/// Description of the "doc_length_exceeded" tag state: The Paper doc would be
/// too large, split the content into multiple docs.
///
/// @return An initialized instance.
///
- (instancetype)initWithDocLengthExceeded;

///
/// Initializes union class with tag state of "image_size_exceeded".
///
/// Description of the "image_size_exceeded" tag state: The imported document
/// contains an image that is too large. The current limit is 1MB. This only
/// applies to HTML with data URI.
///
/// @return An initialized instance.
///
- (instancetype)initWithImageSizeExceeded;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

///
/// Initializes union class with tag state of "invalid_path".
///
/// Description of the "invalid_path" tag state: The file could not be saved to
/// the specified location.
///
/// @return An initialized instance.
///
- (instancetype)initWithInvalidPath;

///
/// Initializes union class with tag state of "email_unverified".
///
/// Description of the "email_unverified" tag state: The user's email must be
/// verified to create Paper docs.
///
/// @return An initialized instance.
///
- (instancetype)initWithEmailUnverified;

///
/// Initializes union class with tag state of "invalid_file_extension".
///
/// Description of the "invalid_file_extension" tag state: The file path must
/// end in .paper.
///
/// @return An initialized instance.
///
- (instancetype)initWithInvalidFileExtension;

///
/// Initializes union class with tag state of "paper_disabled".
///
/// Description of the "paper_disabled" tag state: Paper is disabled for your
/// team.
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperDisabled;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value
/// "insufficient_permissions".
///
/// @return Whether the union's current tag state has value
/// "insufficient_permissions".
///
- (BOOL)isInsufficientPermissions;

///
/// Retrieves whether the union's current tag state has value
/// "content_malformed".
///
/// @return Whether the union's current tag state has value "content_malformed".
///
- (BOOL)isContentMalformed;

///
/// Retrieves whether the union's current tag state has value
/// "doc_length_exceeded".
///
/// @return Whether the union's current tag state has value
/// "doc_length_exceeded".
///
- (BOOL)isDocLengthExceeded;

///
/// Retrieves whether the union's current tag state has value
/// "image_size_exceeded".
///
/// @return Whether the union's current tag state has value
/// "image_size_exceeded".
///
- (BOOL)isImageSizeExceeded;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves whether the union's current tag state has value "invalid_path".
///
/// @return Whether the union's current tag state has value "invalid_path".
///
- (BOOL)isInvalidPath;

///
/// Retrieves whether the union's current tag state has value
/// "email_unverified".
///
/// @return Whether the union's current tag state has value "email_unverified".
///
- (BOOL)isEmailUnverified;

///
/// Retrieves whether the union's current tag state has value
/// "invalid_file_extension".
///
/// @return Whether the union's current tag state has value
/// "invalid_file_extension".
///
- (BOOL)isInvalidFileExtension;

///
/// Retrieves whether the union's current tag state has value "paper_disabled".
///
/// @return Whether the union's current tag state has value "paper_disabled".
///
- (BOOL)isPaperDisabled;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBFILESPaperCreateError` union.
///
@interface DBFILESPaperCreateErrorSerializer : NSObject

///
/// Serializes `DBFILESPaperCreateError` instances.
///
/// @param instance An instance of the `DBFILESPaperCreateError` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESPaperCreateError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESPaperCreateError *)instance;

///
/// Deserializes `DBFILESPaperCreateError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESPaperCreateError` API object.
///
/// @return An instantiation of the `DBFILESPaperCreateError` object.
///
+ (DBFILESPaperCreateError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
