///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESListFolderLongpollResult;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `ListFolderLongpollResult` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESListFolderLongpollResult : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Indicates whether new changes are available. If true, call
/// `listFolderContinue` to retrieve the changes.
@property (nonatomic, readonly) NSNumber *changes;

/// If present, backoff for at least this many seconds before calling
/// `listFolderLongpoll` again.
@property (nonatomic, readonly, nullable) NSNumber *backoff;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param changes Indicates whether new changes are available. If true, call
/// `listFolderContinue` to retrieve the changes.
/// @param backoff If present, backoff for at least this many seconds before
/// calling `listFolderLongpoll` again.
///
/// @return An initialized instance.
///
- (instancetype)initWithChanges:(NSNumber *)changes backoff:(nullable NSNumber *)backoff;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param changes Indicates whether new changes are available. If true, call
/// `listFolderContinue` to retrieve the changes.
///
/// @return An initialized instance.
///
- (instancetype)initWithChanges:(NSNumber *)changes;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `ListFolderLongpollResult` struct.
///
@interface DBFILESListFolderLongpollResultSerializer : NSObject

///
/// Serializes `DBFILESListFolderLongpollResult` instances.
///
/// @param instance An instance of the `DBFILESListFolderLongpollResult` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESListFolderLongpollResult` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESListFolderLongpollResult *)instance;

///
/// Deserializes `DBFILESListFolderLongpollResult` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESListFolderLongpollResult` API object.
///
/// @return An instantiation of the `DBFILESListFolderLongpollResult` object.
///
+ (DBFILESListFolderLongpollResult *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
