///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILEPROPERTIESPropertiesSearchMatch;
@class DBFILEPROPERTIESPropertyGroup;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `PropertiesSearchMatch` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILEPROPERTIESPropertiesSearchMatch : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The ID for the matched file or folder.
@property (nonatomic, readonly, copy) NSString *id_;

/// The path for the matched file or folder.
@property (nonatomic, readonly, copy) NSString *path;

/// Whether the file or folder is deleted.
@property (nonatomic, readonly) NSNumber *isDeleted;

/// List of custom property groups associated with the file.
@property (nonatomic, readonly) NSArray<DBFILEPROPERTIESPropertyGroup *> *propertyGroups;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param id_ The ID for the matched file or folder.
/// @param path The path for the matched file or folder.
/// @param isDeleted Whether the file or folder is deleted.
/// @param propertyGroups List of custom property groups associated with the
/// file.
///
/// @return An initialized instance.
///
- (instancetype)initWithId_:(NSString *)id_
                       path:(NSString *)path
                  isDeleted:(NSNumber *)isDeleted
             propertyGroups:(NSArray<DBFILEPROPERTIESPropertyGroup *> *)propertyGroups;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `PropertiesSearchMatch` struct.
///
@interface DBFILEPROPERTIESPropertiesSearchMatchSerializer : NSObject

///
/// Serializes `DBFILEPROPERTIESPropertiesSearchMatch` instances.
///
/// @param instance An instance of the `DBFILEPROPERTIESPropertiesSearchMatch`
/// API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILEPROPERTIESPropertiesSearchMatch` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILEPROPERTIESPropertiesSearchMatch *)instance;

///
/// Deserializes `DBFILEPROPERTIESPropertiesSearchMatch` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILEPROPERTIESPropertiesSearchMatch` API object.
///
/// @return An instantiation of the `DBFILEPROPERTIESPropertiesSearchMatch`
/// object.
///
+ (DBFILEPROPERTIESPropertiesSearchMatch *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
