///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBCOMMONPathRoot;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `PathRoot` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBCOMMONPathRoot : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBCOMMONPathRootTag` enum type represents the possible tag states with
/// which the `DBCOMMONPathRoot` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBCOMMONPathRootTag){
    /// Paths are relative to the authenticating user's home namespace, whether
    /// or not that user belongs to a team.
    DBCOMMONPathRootHome,

    /// Paths are relative to the authenticating user's root namespace (This
    /// results in `invalidRoot` in `DBCOMMONPathRootError` if the user's root
    /// namespace has changed.).
    DBCOMMONPathRootRoot,

    /// Paths are relative to given namespace id (This results in `noPermission`
    /// in `DBCOMMONPathRootError` if you don't have access to this namespace.).
    DBCOMMONPathRootNamespaceId,

    /// (no description).
    DBCOMMONPathRootOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBCOMMONPathRootTag tag;

/// Paths are relative to the authenticating user's root namespace (This results
/// in `invalidRoot` in `DBCOMMONPathRootError` if the user's root namespace has
/// changed.). @note Ensure the `isRoot` method returns true before accessing,
/// otherwise a runtime exception will be raised.
@property (nonatomic, readonly, copy) NSString *root;

/// Paths are relative to given namespace id (This results in `noPermission` in
/// `DBCOMMONPathRootError` if you don't have access to this namespace.). @note
/// Ensure the `isNamespaceId` method returns true before accessing, otherwise a
/// runtime exception will be raised.
@property (nonatomic, readonly, copy) NSString *namespaceId;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "home".
///
/// Description of the "home" tag state: Paths are relative to the
/// authenticating user's home namespace, whether or not that user belongs to a
/// team.
///
/// @return An initialized instance.
///
- (instancetype)initWithHome;

///
/// Initializes union class with tag state of "root".
///
/// Description of the "root" tag state: Paths are relative to the
/// authenticating user's root namespace (This results in `invalidRoot` in
/// `DBCOMMONPathRootError` if the user's root namespace has changed.).
///
/// @param root Paths are relative to the authenticating user's root namespace
/// (This results in `invalidRoot` in `DBCOMMONPathRootError` if the user's root
/// namespace has changed.).
///
/// @return An initialized instance.
///
- (instancetype)initWithRoot:(NSString *)root;

///
/// Initializes union class with tag state of "namespace_id".
///
/// Description of the "namespace_id" tag state: Paths are relative to given
/// namespace id (This results in `noPermission` in `DBCOMMONPathRootError` if
/// you don't have access to this namespace.).
///
/// @param namespaceId Paths are relative to given namespace id (This results in
/// `noPermission` in `DBCOMMONPathRootError` if you don't have access to this
/// namespace.).
///
/// @return An initialized instance.
///
- (instancetype)initWithNamespaceId:(NSString *)namespaceId;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "home".
///
/// @return Whether the union's current tag state has value "home".
///
- (BOOL)isHome;

///
/// Retrieves whether the union's current tag state has value "root".
///
/// @note Call this method and ensure it returns true before accessing the
/// `root` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "root".
///
- (BOOL)isRoot;

///
/// Retrieves whether the union's current tag state has value "namespace_id".
///
/// @note Call this method and ensure it returns true before accessing the
/// `namespaceId` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "namespace_id".
///
- (BOOL)isNamespaceId;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBCOMMONPathRoot` union.
///
@interface DBCOMMONPathRootSerializer : NSObject

///
/// Serializes `DBCOMMONPathRoot` instances.
///
/// @param instance An instance of the `DBCOMMONPathRoot` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBCOMMONPathRoot` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBCOMMONPathRoot *)instance;

///
/// Deserializes `DBCOMMONPathRoot` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBCOMMONPathRoot` API object.
///
/// @return An instantiation of the `DBCOMMONPathRoot` object.
///
+ (DBCOMMONPathRoot *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
