///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBAUTHTokenFromOAuth1Error;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `TokenFromOAuth1Error` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBAUTHTokenFromOAuth1Error : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBAUTHTokenFromOAuth1ErrorTag` enum type represents the possible tag
/// states with which the `DBAUTHTokenFromOAuth1Error` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBAUTHTokenFromOAuth1ErrorTag){
    /// Part or all of the OAuth 1.0 access token info is invalid.
    DBAUTHTokenFromOAuth1ErrorInvalidOauth1TokenInfo,

    /// The authorized app does not match the app associated with the supplied
    /// access token.
    DBAUTHTokenFromOAuth1ErrorAppIdMismatch,

    /// (no description).
    DBAUTHTokenFromOAuth1ErrorOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBAUTHTokenFromOAuth1ErrorTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "invalid_oauth1_token_info".
///
/// Description of the "invalid_oauth1_token_info" tag state: Part or all of the
/// OAuth 1.0 access token info is invalid.
///
/// @return An initialized instance.
///
- (instancetype)initWithInvalidOauth1TokenInfo;

///
/// Initializes union class with tag state of "app_id_mismatch".
///
/// Description of the "app_id_mismatch" tag state: The authorized app does not
/// match the app associated with the supplied access token.
///
/// @return An initialized instance.
///
- (instancetype)initWithAppIdMismatch;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value
/// "invalid_oauth1_token_info".
///
/// @return Whether the union's current tag state has value
/// "invalid_oauth1_token_info".
///
- (BOOL)isInvalidOauth1TokenInfo;

///
/// Retrieves whether the union's current tag state has value "app_id_mismatch".
///
/// @return Whether the union's current tag state has value "app_id_mismatch".
///
- (BOOL)isAppIdMismatch;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBAUTHTokenFromOAuth1Error` union.
///
@interface DBAUTHTokenFromOAuth1ErrorSerializer : NSObject

///
/// Serializes `DBAUTHTokenFromOAuth1Error` instances.
///
/// @param instance An instance of the `DBAUTHTokenFromOAuth1Error` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBAUTHTokenFromOAuth1Error` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBAUTHTokenFromOAuth1Error *)instance;

///
/// Deserializes `DBAUTHTokenFromOAuth1Error` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBAUTHTokenFromOAuth1Error` API object.
///
/// @return An instantiation of the `DBAUTHTokenFromOAuth1Error` object.
///
+ (DBAUTHTokenFromOAuth1Error *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
