//
//  UIView+Appearance.m
//  
//
//  Created by Mike on 13/5/2.
//  
//

#import "UIView+Appearance.h"

@implementation UIView (Appearance)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

//===============================================================================
//
//===============================================================================
- (void)setBorderColor:(UIColor *)borderColor
{
	self.layer.borderColor = borderColor.CGColor;
}

//===============================================================================
//
//===============================================================================
- (void)setBorderWidth:(CGFloat)borderWidth
{
	self.layer.borderWidth = borderWidth;
}

//===============================================================================
//
//===============================================================================
- (void)setCornerRadius:(CGFloat)radius
{
	self.layer.cornerRadius		= radius;
	self.layer.masksToBounds	= YES;
}

//===============================================================================
//
//===============================================================================
- (void)setShadowColor:(UIColor *)shadowColor
{
	self.layer.shadowColor = shadowColor.CGColor;
}

//===============================================================================
//
//===============================================================================
- (void)setShadowOffset:(CGSize)shadowOffset
{
	self.layer.shadowOffset = shadowOffset;
}

//===============================================================================
//
//===============================================================================
- (void)setOuterGlowWithColor:(UIColor *)color radius:(CGFloat)radius opacity:(CGFloat)opacity
{
    self.layer.shadowColor = color.CGColor;
    self.layer.shadowRadius = radius;
    self.layer.shadowOpacity = opacity;
    self.layer.shadowOffset = CGSizeZero;
    
    // !! fix warning
    // see: https://stackoverflow.com/a/64359313
    self.layer.shouldRasterize = YES;
    self.layer.rasterizationScale = [UIScreen mainScreen].scale;
}

@end
