//
//  UIDocumentInteractionController+CanOpenIn.m
//
//  Created by Bill Cheng on 2014/2/24.
//  Copyright (c) 2014年 Penpower. All rights reserved.
//

#import "UIDocumentInteractionController+CanOpenIn.h"

@implementation UIDocumentInteractionController (CanOpenIn)

+ (BOOL)canUseOpenInWithFileExtension:(NSString *)fileExtension
{
    if (NSFoundationVersionNumber < NSFoundationVersionNumber_iPhoneOS_3_2) {
        return NO;
    }

    // !! Because there are no method to determine if openin can be used,
    // !! we use a fake file to popup openin and check if it is successful instead.

    NSString *tempDirectory = NSTemporaryDirectory();

    NSString *filePath = [NSString stringWithFormat:@"%@/check.%@", tempDirectory, fileExtension];

    [[NSFileManager defaultManager] createFileAtPath:filePath contents:nil attributes:nil];

    NSURL *fileURL = [NSURL fileURLWithPath:filePath];
    UIDocumentInteractionController *controller = [UIDocumentInteractionController interactionControllerWithURL:fileURL];

    UIView *view = [UIApplication sharedApplication].keyWindow;

    BOOL hasOpenInApp = [controller presentOpenInMenuFromRect:CGRectZero
                                                       inView:view
                                                     animated:NO];

    [controller dismissMenuAnimated:NO];

    [[NSFileManager defaultManager] removeItemAtPath:filePath error:nil];

    return hasOpenInApp;
}

@end
