//
//  UIDevice+IdentifierAddition.m
//
//
//  Created by Eddie on 2011/11/1.
//  Fixed   by Howard on 2013/09/06
//  Copyright (c) 2011年 Penpower. All rights reserved.
//

#import "UIDevice+IdentifierAddition.h"
#import <CommonCrypto/CommonDigest.h>

#include <sys/socket.h> // Per msqr
#include <sys/sysctl.h>
#include <net/if.h>
#include <net/if_dl.h>

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation UIDevice (IdentifierAddition)

#pragma mark - Private Methods

//=============================================================================================================
//
//=============================================================================================================
+ (NSString *)hashString:(NSString *)string
{
    NSMutableString *hashString = nil;
    
    do
    {
        if(string==nil || [string length]==0)
        {
            break;
        }

        //////////////////////////////////////////////////
        
        hashString = [NSMutableString stringWithCapacity:CC_MD5_DIGEST_LENGTH*2];
        if(hashString==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        const char *data = [string UTF8String];
        unsigned char outputBuffer[CC_MD5_DIGEST_LENGTH];
        CC_MD5(data, (CC_LONG)strlen(data), outputBuffer);
        
        //////////////////////////////////////////////////
        
        for(NSInteger index=0; index<CC_MD5_DIGEST_LENGTH; index++)
        {
            [hashString appendFormat:@"%02x", outputBuffer[index]];
        }
        
    } while (0);
   
    return hashString;
}

//=============================================================================================================
//
//=============================================================================================================
+ (NSString *)macaddress
{
    NSString *macaddress = nil;

	//////////////////////////////////////////////////
	
	char *buf	= NULL;
	int  mib[6] = {CTL_NET, AF_ROUTE, 0, AF_LINK, NET_RT_IFLIST};
	
	//////////////////////////////////////////////////    
	
    do
    {
        if ((mib[5] = if_nametoindex("en0")) == 0)
        {
            printf("Error: if_nametoindex error\n");
            break;
        }
        
        //////////////////////////////////////////////////
        
        size_t len = 0;
        if(sysctl(mib, 6, NULL, &len, NULL, 0)<0)
        {
            printf("Error: sysctl, take 1\n");
            break;
        }
        
        //////////////////////////////////////////////////
        
        buf = malloc(len);
        if(buf==NULL)
        {
            printf("Could not allocate memory. error!\n");
            break;
        }
        
        //////////////////////////////////////////////////
        
        if(sysctl(mib, 6, buf, &len, NULL, 0)<0)
        {
            printf("Error: sysctl, take 2");
            break;
        }
        
        //////////////////////////////////////////////////
        
        struct if_msghdr    *ifm = (struct if_msghdr *)buf;
        struct sockaddr_dl  *sdl = (struct sockaddr_dl *)(ifm + 1);
        unsigned char       *ptr = (unsigned char *)LLADDR(sdl);
        
        macaddress = [NSString stringWithFormat:@"%02X:%02X:%02X:%02X:%02X:%02X",
                      *ptr,
                      *(ptr+1),
                      *(ptr+2),
                      *(ptr+3),
                      *(ptr+4),
                      *(ptr+5)];

    } while (0);
   
    //////////////////////////////////////////////////
   
    if(buf!=NULL)
    {
        free(buf);
    }
    
    //////////////////////////////////////////////////
   
    return macaddress;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Public Methods

static NSString *g_uniqueDeviceIdentifier = nil;

//=============================================================================================================
// 
//=============================================================================================================
+ (NSString *)uniqueDeviceIdentifier
{
    do
    {
        if(g_uniqueDeviceIdentifier!=nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSString *macaddress = [self macaddress];
        if(macaddress==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSString *bundleIdentifier = [[NSBundle mainBundle] bundleIdentifier];
        if(bundleIdentifier==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSString *stringToHash = [NSString stringWithFormat:@"%@%@", macaddress, bundleIdentifier];
        if(stringToHash==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        g_uniqueDeviceIdentifier = [[self hashString:stringToHash] retain];
    
    }while(0);
    
    return g_uniqueDeviceIdentifier;
}

//=============================================================================================================
// 
//=============================================================================================================
+ (NSString *)uniqueGlobalDeviceIdentifier
{
    NSString *uniqueGlobalDeviceIdentifier = nil;
    
    do
    {
        NSString *macaddress = [self macaddress];
        if(macaddress==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        uniqueGlobalDeviceIdentifier = [self hashString:macaddress];
        
    }while(0);
    
    return uniqueGlobalDeviceIdentifier;
}

//=============================================================================================================
// 
//=============================================================================================================
+ (uint)uniqueDeviceIdentifierIntValueToIndex:(NSUInteger)index
{
    uint hexValue = 0;
    
    do
    {
        NSString *uniqueDeviceIdentifier = [self uniqueDeviceIdentifier];
        if(uniqueDeviceIdentifier==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSString *subString = [uniqueDeviceIdentifier substringToIndex:index];
        if(subString==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSScanner *scanner = [NSScanner scannerWithString:subString];
        if(scanner==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        [scanner scanHexInt:&hexValue];
        
    }while(0);
    
    return hexValue;
}

@end
