//
//  UIDevice+DeviceModel.m
//  
//
//  Created by Mike on 2010/10/4.
//
//

#import "UIDevice+DeviceModel.h"
#import <sys/sysctl.h>

@implementation UIDevice(DeviceModel)

//===============================================================================
//
//===============================================================================
+ (BOOL)isSupportSiri
{
    BOOL result = YES;
    
    PPDeviceModelID deviceID = [UIDevice deviceModelID];
    
    if((deviceID>PPDeviceModelID_iPhone     && deviceID<=PPDeviceModelID_iPhone_4)  ||
       (deviceID>PPDeviceModelID_iPad       && deviceID<=PPDeviceModelID_iPad_2)    ||
       (deviceID>PPDeviceModelID_iPod_1G    && deviceID<=PPDeviceModelID_iPod_4G)   )
    {
        result = NO;
    }
    
    return result;
}


//===============================================================================
//
//===============================================================================
+ (NSString *)deviceModelForSimulator
{
    NSDictionary *environment = [[NSProcessInfo processInfo] environment];
    
    return environment[@"SIMULATOR_MODEL_IDENTIFIER"];
}


//===============================================================================
//
//===============================================================================
+ (NSString *)deviceModel
{
#if TARGET_OS_SIMULATOR
    return [self deviceModelForSimulator];
#else
	size_t size;
	sysctlbyname("hw.machine", NULL, &size, NULL, 0);
	char *machine = malloc(size);
	sysctlbyname("hw.machine", machine, &size, NULL, 0);
	NSString *deviceModel = [NSString stringWithCString:machine encoding: NSUTF8StringEncoding];
	free(machine);
	
	return deviceModel;
#endif
}


//===============================================================================
//
//===============================================================================
+ (NSString *)deviceModelName
{
	PPDeviceModelID deviceVersionID = [UIDevice deviceModelID];
	
    switch(deviceVersionID)
    {
        case PPDeviceModelID_iPhone_16e:    return PPDeviceModelName_iPhone16e;
        case PPDeviceModelID_iPhone_16Plus: return PPDeviceModelName_iPhone16Plus;
        case PPDeviceModelID_iPhone_16ProMax:   return PPDeviceModelName_iPhone16ProMax;
        case PPDeviceModelID_iPhone_16Pro:  return PPDeviceModelName_iPhone16Pro;
        case PPDeviceModelID_iPhone_16: return PPDeviceModelName_iPhone16;
        case PPDeviceModelID_iPhone_15Plus: return PPDeviceModelName_iPhone15Plus;
        case PPDeviceModelID_iPhone_15ProMax:   return PPDeviceModelName_iPhone15ProMax;
        case PPDeviceModelID_iPhone_15Pro:  return PPDeviceModelName_iPhone15Pro;
        case PPDeviceModelID_iPhone_15: return PPDeviceModelName_iPhone15;
        case PPDeviceModelID_iPhone_14Plus: return PPDeviceModelName_iPhone14Plus;
        case PPDeviceModelID_iPhone_14ProMax:   return PPDeviceModelName_iPhone14ProMax;
        case PPDeviceModelID_iPhone_14Pro:  return PPDeviceModelName_iPhone14Pro;
        case PPDeviceModelID_iPhone_14: return PPDeviceModelName_iPhone14;
        case PPDeviceModelID_iPhone_SE3:    return PPDeviceModelName_iPhoneSE3;
        case PPDeviceModelID_iPhone_13:     return PPDeviceModelName_iPhone13;
        case PPDeviceModelID_iPhone_13Mini: return PPDeviceModelName_iPhone13Mini;
        case PPDeviceModelID_iPhone_13Pro:  return PPDeviceModelName_iPhone13Pro;
        case PPDeviceModelID_iPhone_13ProMax: return PPDeviceModelName_iPhone13ProMax;
        case PPDeviceModelID_iPhone_12:     return PPDeviceModelName_iPhone12;
        case PPDeviceModelID_iPhone_12Mini: return PPDeviceModelName_iPhone12Mini;
        case PPDeviceModelID_iPhone_12Pro: return PPDeviceModelName_iPhone12Pro;
        case PPDeviceModelID_iPhone_12ProMax: return PPDeviceModelName_iPhone12ProMax;
        case PPDeviceModelID_iPhone_SE2:     return PPDeviceModelName_iPhoneSE2;
        case PPDeviceModelID_iPhone_11ProMax:  return PPDeviceModelName_iPhone11ProMax;
        case PPDeviceModelID_iPhone_11Pro:  return PPDeviceModelName_iPhone11Pro;
        case PPDeviceModelID_iPhone_11:      return PPDeviceModelName_iPhone11;
        case PPDeviceModelID_iPhone_XR:      return PPDeviceModelName_iPhoneXR;
        case PPDeviceModelID_iPhone_XSMax:      return PPDeviceModelName_iPhoneXSMax;
        case PPDeviceModelID_iPhone_XS:      return PPDeviceModelName_iPhoneXS;
        case PPDeviceModelID_iPhone_X:      return PPDeviceModelName_iPhoneX;
        case PPDeviceModelID_iPhone_8Plus:  return PPDeviceModelName_iPhone8Plus;
        case PPDeviceModelID_iPhone_8:      return PPDeviceModelName_iPhone8;
        case PPDeviceModelID_iPhone_7Plus:  return PPDeviceModelName_iPhone7Plus;
        case PPDeviceModelID_iPhone_7:      return PPDeviceModelName_iPhone7;
        case PPDeviceModelID_iPhone_SE:     return PPDeviceModelName_iPhoneSE;
        case PPDeviceModelID_iPhone_6sPlus:	return PPDeviceModelName_iPhone6sPlus;
        case PPDeviceModelID_iPhone_6s:		return PPDeviceModelName_iPhone6s;
        case PPDeviceModelID_iPhone_6Plus:	return PPDeviceModelName_iPhone6Plus;
        case PPDeviceModelID_iPhone_6:		return PPDeviceModelName_iPhone6;
        case PPDeviceModelID_iPhone_5S:		return PPDeviceModelName_iPhone5S;
        case PPDeviceModelID_iPhone_5C:		return PPDeviceModelName_iPhone5C;
		case PPDeviceModelID_iPhone_5:		return PPDeviceModelName_iPhone5;
		case PPDeviceModelID_iPhone_4S:     return PPDeviceModelName_iPhone4S;
		case PPDeviceModelID_iPhone_4:		return PPDeviceModelName_iPhone4;
		case PPDeviceModelID_iPhone_3GS:    return PPDeviceModelName_iPhone3GS;
		case PPDeviceModelID_iPhone_3G:     return PPDeviceModelName_iPhone3G;
		case PPDeviceModelID_iPhone_1G:     return PPDeviceModelName_iPhone1G;
            
        case PPDeviceModelID_iPad_11:       return PPDeviceModelName_iPad11;
        case PPDeviceModelID_iPad_Air7:     return PPDeviceModelName_iPadAir7;
        case PPDeviceModelID_iPad_Pro7:     return PPDeviceModelName_iPadPro7;
        case PPDeviceModelID_iPad_mini7:    return PPDeviceModelName_iPadmini7;
        case PPDeviceModelID_iPad_Air6:     return PPDeviceModelName_iPadAir6;
        case PPDeviceModelID_iPad_Pro6:     return PPDeviceModelName_iPadPro6;
        case PPDeviceModelID_iPad_mini6:    return PPDeviceModelName_iPadmini6;
        case PPDeviceModelID_iPad_10:       return PPDeviceModelName_iPad10;
        case PPDeviceModelID_iPad_Air5:     return PPDeviceModelName_iPadAir5;
        case PPDeviceModelID_iPad_Pro5:     return PPDeviceModelName_iPadPro5;
        case PPDeviceModelID_iPad_Air4:     return PPDeviceModelName_iPadAir4;
        case PPDeviceModelID_iPad_9:        return PPDeviceModelName_iPad9;
        case PPDeviceModelID_iPad_8:        return PPDeviceModelName_iPad8;
        case PPDeviceModelID_iPad_Pro4:     return PPDeviceModelName_iPadPro4;
        case PPDeviceModelID_iPad_7:        return PPDeviceModelName_iPad7;
        case PPDeviceModelID_iPad_Air3:     return PPDeviceModelName_iPadAir3;
        case PPDeviceModelID_iPad_mini5:    return PPDeviceModelName_iPadMini5;
        case PPDeviceModelID_iPad_Pro3:     return PPDeviceModelName_iPadPro3;
        case PPDeviceModelID_iPad_Pro_10_5: return PPDeviceModelName_iPadPro_10_5;
        case PPDeviceModelID_iPad_5:        return PPDeviceModelName_iPadPro;
        case PPDeviceModelID_iPad_Pro2:     return PPDeviceModelName_iPadPro;
        case PPDeviceModelID_iPad_Pro:		return PPDeviceModelName_iPadPro;
        case PPDeviceModelID_iPad_Air2:		return PPDeviceModelName_iPadAir2;
		case PPDeviceModelID_iPad_Air:		return PPDeviceModelName_iPadAir;
        case PPDeviceModelID_iPad_mini4:    return PPDeviceModelName_iPadMini4;
        case PPDeviceModelID_iPad_mini3:    return PPDeviceModelName_iPadMini3;
        case PPDeviceModelID_iPad_mini2:    return PPDeviceModelName_iPadMini2;
		case PPDeviceModelID_iPad_mini:		return PPDeviceModelName_iPadMini;
		case PPDeviceModelID_iPad_4:		return PPDeviceModelName_iPad4;
		case PPDeviceModelID_iPad_3:		return PPDeviceModelName_iPad3;
		case PPDeviceModelID_iPad_2:		return PPDeviceModelName_iPad2;
		case PPDeviceModelID_iPad_1:        return PPDeviceModelName_iPad1;
            
        case PPDeviceModelID_iPod_6G:       return PPDeviceModelName_iPodTouch6G;
		case PPDeviceModelID_iPod_5G:       return PPDeviceModelName_iPodTouch5G;
		case PPDeviceModelID_iPod_4G:       return PPDeviceModelName_iPodTouch4G;
		case PPDeviceModelID_iPod_3G:       return PPDeviceModelName_iPodTouch3G;
		case PPDeviceModelID_iPod_2_5G:     return PPDeviceModelName_iPodTouch2_5G;
		case PPDeviceModelID_iPod_2G:       return PPDeviceModelName_iPodTouch2G;
		case PPDeviceModelID_iPod_1G:       return PPDeviceModelName_iPodTouch1G;

        case PPDeviceModelID_AppleTV4:      return PPDeviceModelName_AppleTV4;
        case PPDeviceModelID_AppleTV3:      return PPDeviceModelName_AppleTV3;
        case PPDeviceModelID_AppleTV2:      return PPDeviceModelName_AppleTV2;
        case PPDeviceModelID_AppleTV1:      return PPDeviceModelName_AppleTV;
        
		case PPDeviceModelID_Simulator:     return PPDeviceModelName_Simulator;
		default:                            return [UIDevice deviceModel];
	}
}

//===============================================================================
//
//===============================================================================
+ (PPDeviceModelID)deviceModelID
{
	NSString *ppdeviceModel = [UIDevice deviceModel];
	// iPhone
    if ([ppdeviceModel isEqualToString:@"iPhone17,5"])    return PPDeviceModelID_iPhone_16e;
    if ([ppdeviceModel isEqualToString:@"iPhone17,4"])    return PPDeviceModelID_iPhone_16Plus;
    if ([ppdeviceModel isEqualToString:@"iPhone17,3"])    return PPDeviceModelID_iPhone_16;
    if ([ppdeviceModel isEqualToString:@"iPhone17,2"])    return PPDeviceModelID_iPhone_16ProMax;
    if ([ppdeviceModel isEqualToString:@"iPhone17,1"])    return PPDeviceModelID_iPhone_16Pro;
    if ([ppdeviceModel isEqualToString:@"iPhone16,2"])    return PPDeviceModelID_iPhone_15ProMax;
    if ([ppdeviceModel isEqualToString:@"iPhone16,1"])    return PPDeviceModelID_iPhone_15Pro;
    if ([ppdeviceModel isEqualToString:@"iPhone15,5"])    return PPDeviceModelID_iPhone_15Plus;
    if ([ppdeviceModel isEqualToString:@"iPhone15,4"])    return PPDeviceModelID_iPhone_15;
    if ([ppdeviceModel isEqualToString:@"iPhone15,3"])    return PPDeviceModelID_iPhone_14ProMax;
    if ([ppdeviceModel isEqualToString:@"iPhone15,2"])    return PPDeviceModelID_iPhone_14Pro;
    if ([ppdeviceModel isEqualToString:@"iPhone14,8"])    return PPDeviceModelID_iPhone_14Plus;
    if ([ppdeviceModel isEqualToString:@"iPhone14,7"])    return PPDeviceModelID_iPhone_14;
    if ([ppdeviceModel isEqualToString:@"iPhone14,6"])    return PPDeviceModelID_iPhone_SE3;
    if ([ppdeviceModel isEqualToString:@"iPhone14,5"])    return PPDeviceModelID_iPhone_13;
    if ([ppdeviceModel isEqualToString:@"iPhone14,4"])    return PPDeviceModelID_iPhone_13Mini;
    if ([ppdeviceModel isEqualToString:@"iPhone14,3"])    return PPDeviceModelID_iPhone_13ProMax;
    if ([ppdeviceModel isEqualToString:@"iPhone14,2"])    return PPDeviceModelID_iPhone_13Pro;
    if ([ppdeviceModel isEqualToString:@"iPhone13,4"])    return PPDeviceModelID_iPhone_12ProMax;
    if ([ppdeviceModel isEqualToString:@"iPhone13,3"])    return PPDeviceModelID_iPhone_12Pro;
    if ([ppdeviceModel isEqualToString:@"iPhone13,2"])    return PPDeviceModelID_iPhone_12;
    if ([ppdeviceModel isEqualToString:@"iPhone13,1"])    return PPDeviceModelID_iPhone_12Mini;
    if ([ppdeviceModel isEqualToString:@"iPhone12,8"])    return PPDeviceModelID_iPhone_SE2;
    if ([ppdeviceModel isEqualToString:@"iPhone12,5"])    return PPDeviceModelID_iPhone_11ProMax;
    if ([ppdeviceModel isEqualToString:@"iPhone12,3"])    return PPDeviceModelID_iPhone_11Pro;
    if ([ppdeviceModel isEqualToString:@"iPhone12,1"])    return PPDeviceModelID_iPhone_11;
    if ([ppdeviceModel isEqualToString:@"iPhone11,8"])    return PPDeviceModelID_iPhone_XR;
    if ([ppdeviceModel isEqualToString:@"iPhone11,6"])    return PPDeviceModelID_iPhone_XSMax;
    if ([ppdeviceModel isEqualToString:@"iPhone11,4"])    return PPDeviceModelID_iPhone_XSMax;
    if ([ppdeviceModel isEqualToString:@"iPhone11,2"])    return PPDeviceModelID_iPhone_XS;
    if ([ppdeviceModel isEqualToString:@"iPhone10,6"])    return PPDeviceModelID_iPhone_X;
    if ([ppdeviceModel isEqualToString:@"iPhone10,3"])    return PPDeviceModelID_iPhone_X;
    if ([ppdeviceModel isEqualToString:@"iPhone10,5"])    return PPDeviceModelID_iPhone_8Plus;
    if ([ppdeviceModel isEqualToString:@"iPhone10,2"])    return PPDeviceModelID_iPhone_8Plus;
    if ([ppdeviceModel isEqualToString:@"iPhone10,4"])    return PPDeviceModelID_iPhone_8;
    if ([ppdeviceModel isEqualToString:@"iPhone10,1"])    return PPDeviceModelID_iPhone_8;
    if ([ppdeviceModel isEqualToString:@"iPhone9,4"])    return PPDeviceModelID_iPhone_7Plus;   //((AT&T/T-Mobile/Global/A1784)
    if ([ppdeviceModel isEqualToString:@"iPhone9,2"])    return PPDeviceModelID_iPhone_7Plus;   //(Verizon/Sprint/Japan/China Mobile)
    if ([ppdeviceModel isEqualToString:@"iPhone9,3"])    return PPDeviceModelID_iPhone_7;       //((AT&T/T-Mobile/Global/A1784)
    if ([ppdeviceModel isEqualToString:@"iPhone9,1"])    return PPDeviceModelID_iPhone_7;       //(Verizon/Sprint/Japan/China Mobile)
    if ([ppdeviceModel isEqualToString:@"iPhone8,4"])    return PPDeviceModelID_iPhone_SE;
    if ([ppdeviceModel isEqualToString:@"iPhone8,2"])    return PPDeviceModelID_iPhone_6sPlus;
    if ([ppdeviceModel isEqualToString:@"iPhone8,1"])    return PPDeviceModelID_iPhone_6s;
    if ([ppdeviceModel isEqualToString:@"iPhone7,2"])    return PPDeviceModelID_iPhone_6;
    if ([ppdeviceModel isEqualToString:@"iPhone7,1"])    return PPDeviceModelID_iPhone_6Plus;
	if ([ppdeviceModel isEqualToString:@"iPhone6,2"])    return PPDeviceModelID_iPhone_5S;
	if ([ppdeviceModel isEqualToString:@"iPhone6,1"])    return PPDeviceModelID_iPhone_5S;
	if ([ppdeviceModel isEqualToString:@"iPhone5,4"])    return PPDeviceModelID_iPhone_5C;
	if ([ppdeviceModel isEqualToString:@"iPhone5,3"])    return PPDeviceModelID_iPhone_5C;
	if ([ppdeviceModel isEqualToString:@"iPhone5,2"])    return PPDeviceModelID_iPhone_5;
	if ([ppdeviceModel isEqualToString:@"iPhone5,1"])    return PPDeviceModelID_iPhone_5;
	if ([ppdeviceModel isEqualToString:@"iPhone4,1"])    return PPDeviceModelID_iPhone_4S;
	if ([ppdeviceModel isEqualToString:@"iPhone3,3"])    return PPDeviceModelID_iPhone_4;
	if ([ppdeviceModel isEqualToString:@"iPhone3,1"])    return PPDeviceModelID_iPhone_4;
	if ([ppdeviceModel isEqualToString:@"iPhone2,1"])    return PPDeviceModelID_iPhone_3GS;
    if ([ppdeviceModel isEqualToString:@"iPhone1,2"])    return PPDeviceModelID_iPhone_3G;
    if ([ppdeviceModel isEqualToString:@"iPhone1,1"])    return PPDeviceModelID_iPhone_1G;

    // undefined iphone model
    if ([ppdeviceModel hasPrefix:@"iPhone"])            return PPDeviceModelID_iPhone;
	
	//iPad
    if ([ppdeviceModel isEqualToString:@"iPad16,6"])      return PPDeviceModelID_iPad_Pro7;     // iPad Pro 12.9 inch 7th Gen
    if ([ppdeviceModel isEqualToString:@"iPad16,5"])      return PPDeviceModelID_iPad_Pro7;     // iPad Pro 12.9 inch 7th Gen
    if ([ppdeviceModel isEqualToString:@"iPad16,4"])      return PPDeviceModelID_iPad_Pro5;     // iPad Pro 11 inch 5th Gen
    if ([ppdeviceModel isEqualToString:@"iPad16,3"])      return PPDeviceModelID_iPad_Pro5;     // iPad Pro 11 inch 5th Gen
    if ([ppdeviceModel isEqualToString:@"iPad16,2"])      return PPDeviceModelID_iPad_mini7;     // iPad mini 7th Gen (WiFi+Cellular)
    if ([ppdeviceModel isEqualToString:@"iPad16,1"])      return PPDeviceModelID_iPad_mini7;     // iPad mini 7th Gen (WiFi)
    if ([ppdeviceModel isEqualToString:@"iPad15,8"])      return PPDeviceModelID_iPad_11;     // iiPad 11th Gen (WiFi+Cellular)
    if ([ppdeviceModel isEqualToString:@"iPad15,7"])      return PPDeviceModelID_iPad_11;     // iPad 11th Gen (WiFi)
    if ([ppdeviceModel isEqualToString:@"iPad15,6"])      return PPDeviceModelID_iPad_Air7;     // iPad Air 13-inch 7th Gen (WiFi+Cellular)
    if ([ppdeviceModel isEqualToString:@"iPad15,5"])      return PPDeviceModelID_iPad_Air7;     // iPad Air 13-inch 7th Gen (WiFi)
    if ([ppdeviceModel isEqualToString:@"iPad15,4"])      return PPDeviceModelID_iPad_Air7;     // iPad Air 11-inch 7th Gen (WiFi+Cellular)
    if ([ppdeviceModel isEqualToString:@"iPad15,3"])      return PPDeviceModelID_iPad_Air7;     // iPad Air 11-inch 7th Gen (WiFi)
    if ([ppdeviceModel isEqualToString:@"iPad14,11"])      return PPDeviceModelID_iPad_Air6;     // iPad Air 13 inch 6th Gen (WiFi+Cellular)
    if ([ppdeviceModel isEqualToString:@"iPad14,10"])      return PPDeviceModelID_iPad_Air6;     // iPad Air 13 inch 6th Gen (WiFi)
    if ([ppdeviceModel isEqualToString:@"iPad14,9"])      return PPDeviceModelID_iPad_Air6;     // iPad Air 11 inch 6th Gen (WiFi+Cellular)
    if ([ppdeviceModel isEqualToString:@"iPad14,8"])      return PPDeviceModelID_iPad_Air6;     // iPad Air 11 inch 6th Gen (WiFi)
    if ([ppdeviceModel isEqualToString:@"iPad14,6"])      return PPDeviceModelID_iPad_Pro6;     // iPad Pro 12.9 inch 6th Gen
    if ([ppdeviceModel isEqualToString:@"iPad14,5"])      return PPDeviceModelID_iPad_Pro6;     // iPad Pro 12.9 inch 6th Gen
    if ([ppdeviceModel isEqualToString:@"iPad14,4"])      return PPDeviceModelID_iPad_Pro4;     // iPad Pro 11 inch 4th Gen
    if ([ppdeviceModel isEqualToString:@"iPad14,3"])      return PPDeviceModelID_iPad_Pro4;     // iPad Pro 11 inch 4th Gen
    if ([ppdeviceModel isEqualToString:@"iPad14,2"])      return PPDeviceModelID_iPad_mini6;     // iPad mini 6th Gen (WiFi+Cellular)
    if ([ppdeviceModel isEqualToString:@"iPad14,1"])      return PPDeviceModelID_iPad_mini6;     // iPad mini 6th Gen (WiFi)
    if ([ppdeviceModel isEqualToString:@"iPad13,19"])      return PPDeviceModelID_iPad_10;     // iPad 10th Gen
    if ([ppdeviceModel isEqualToString:@"iPad13,18"])      return PPDeviceModelID_iPad_10;     // iPad 10th Gen
    if ([ppdeviceModel isEqualToString:@"iPad13,17"])      return PPDeviceModelID_iPad_Air5;     // iPad Air 5th Gen (WiFi+Cellular)
    if ([ppdeviceModel isEqualToString:@"iPad13,16"])      return PPDeviceModelID_iPad_Air5;     // iPad Air 5th Gen (WiFi)
    if ([ppdeviceModel isEqualToString:@"iPad13,11"])      return PPDeviceModelID_iPad_Pro5;     // iPad Pro 12.9 inch 5th Gen
    if ([ppdeviceModel isEqualToString:@"iPad13,10"])      return PPDeviceModelID_iPad_Pro5;     // iPad Pro 12.9 inch 5th Gen
    if ([ppdeviceModel isEqualToString:@"iPad13,9"])      return PPDeviceModelID_iPad_Pro5;     // iPad Pro 12.9 inch 5th Gen
    if ([ppdeviceModel isEqualToString:@"iPad13,8"])      return PPDeviceModelID_iPad_Pro5;     // iPad Pro 12.9 inch 5th Gen
    if ([ppdeviceModel isEqualToString:@"iPad13,7"])      return PPDeviceModelID_iPad_Pro5;     // iPad Pro 11 inch 5th Gen
    if ([ppdeviceModel isEqualToString:@"iPad13,6"])      return PPDeviceModelID_iPad_Pro5;     // iPad Pro 11 inch 5th Gen
    if ([ppdeviceModel isEqualToString:@"iPad13,5"])      return PPDeviceModelID_iPad_Pro5;     // iPad Pro 11 inch 5th Gen
    if ([ppdeviceModel isEqualToString:@"iPad13,4"])      return PPDeviceModelID_iPad_Pro5;     // iPad Pro 11 inch 5th Gen
    if ([ppdeviceModel isEqualToString:@"iPad13,2"])      return PPDeviceModelID_iPad_Air4;     // iPad Air 4rd Gen
    if ([ppdeviceModel isEqualToString:@"iPad13,1"])      return PPDeviceModelID_iPad_Air4;     // iPad Air 4rd Gen (WiFi)

    if ([ppdeviceModel isEqualToString:@"iPad12,2"])      return PPDeviceModelID_iPad_9;     // iPad 9th Gen (WiFi+Cellular)
    if ([ppdeviceModel isEqualToString:@"iPad12,1"])      return PPDeviceModelID_iPad_9;     // iPad 9th Gen (WiFi)
    
    if ([ppdeviceModel isEqualToString:@"iPad11,7"])      return PPDeviceModelID_iPad_8;     // iPad 10.2" 8th Gen
    if ([ppdeviceModel isEqualToString:@"iPad11,6"])      return PPDeviceModelID_iPad_8;     // iPad 10.2" 8th Gen (Wi-Fi Only)
    if ([ppdeviceModel isEqualToString:@"iPad11,4"])      return PPDeviceModelID_iPad_Air3;     // iPad Air 3rd Gen
    if ([ppdeviceModel isEqualToString:@"iPad11,3"])      return PPDeviceModelID_iPad_Air3;     // iPad Air 3rd Gen (WiFi)
    if ([ppdeviceModel isEqualToString:@"iPad11,2"])      return PPDeviceModelID_iPad_mini5;     // iPad mini 5th Gen
    if ([ppdeviceModel isEqualToString:@"iPad11,1"])      return PPDeviceModelID_iPad_mini5;     // iPad mini 5th Gen (WiFi)
    

    if ([ppdeviceModel isEqualToString:@"iPad8,12"])      return PPDeviceModelID_iPad_Pro4;     // iPad Pro 3rd Gen (12.9 inch, WiFi+Cellular)
    if ([ppdeviceModel isEqualToString:@"iPad8,11"])      return PPDeviceModelID_iPad_Pro4;     // iPad Pro 3rd Gen (12.9 inch, WiFi+Cellular)
    if ([ppdeviceModel isEqualToString:@"iPad8,10"])      return PPDeviceModelID_iPad_Pro4;     // iPad Pro 3rd Gen (12.9 inch, WiFi+Cellular)
    if ([ppdeviceModel isEqualToString:@"iPad8,9"])      return PPDeviceModelID_iPad_Pro4;     // iPad Pro 3rd Gen (12.9 inch, WiFi+Cellular)

    if ([ppdeviceModel isEqualToString:@"iPad7,11"])      return PPDeviceModelID_iPad_7;     // iPad 7th Gen (WiFi+Cellular)
    if ([ppdeviceModel isEqualToString:@"iPad7,12"])      return PPDeviceModelID_iPad_7;     // iPad 7th Gen (WiFi+Cellular)

    if ([ppdeviceModel isEqualToString:@"iPad8,8"])      return PPDeviceModelID_iPad_Pro3;     // iPad Pro 3rd Gen (12.9 inch, WiFi+Cellular)
    if ([ppdeviceModel isEqualToString:@"iPad8,7"])      return PPDeviceModelID_iPad_Pro3;     // iPad Pro 3rd Gen (12.9 inch, WiFi+Cellular)
    if ([ppdeviceModel isEqualToString:@"iPad8,6"])      return PPDeviceModelID_iPad_Pro3;     // iPad Pro 3rd Gen (12.9 inch, 1TB, WiFi)
    if ([ppdeviceModel isEqualToString:@"iPad8,5"])      return PPDeviceModelID_iPad_Pro3;     // iPad Pro 3rd Gen (12.9 inch, WiFi)
    if ([ppdeviceModel isEqualToString:@"iPad8,4"])      return PPDeviceModelID_iPad_Pro3;     // iPad Pro 3rd Gen (11 inch, 1TB, WiFi+Cellular)
    if ([ppdeviceModel isEqualToString:@"iPad8,3"])      return PPDeviceModelID_iPad_Pro3;     // iPad Pro 3rd Gen (11 inch, WiFi+Cellular)
    if ([ppdeviceModel isEqualToString:@"iPad8,2"])      return PPDeviceModelID_iPad_Pro3;     // iPad Pro 3rd Gen (11 inch, 1TB, WiFi)
    if ([ppdeviceModel isEqualToString:@"iPad8,1"])      return PPDeviceModelID_iPad_Pro3;     // iPad Pro 3rd Gen (11 inch, WiFi)

    if ([ppdeviceModel isEqualToString:@"iPad7,6"])      return PPDeviceModelID_iPad_6;     // iPad 6th Gen (WiFi+Cellular)
    if ([ppdeviceModel isEqualToString:@"iPad7,5"])      return PPDeviceModelID_iPad_6;     // iPad 6th Gen (WiFi)

    if ([ppdeviceModel isEqualToString:@"iPad7,4"])      return PPDeviceModelID_iPad_Pro_10_5;     // iPad Pro 10.5-inch
    if ([ppdeviceModel isEqualToString:@"iPad7,3"])      return PPDeviceModelID_iPad_Pro_10_5;     // iPad Pro 10.5-inch

    if ([ppdeviceModel isEqualToString:@"iPad7,2"])      return PPDeviceModelID_iPad_Pro2;     // iPad Pro (12.9-inch, 2nd generation)
    if ([ppdeviceModel isEqualToString:@"iPad7,1"])      return PPDeviceModelID_iPad_Pro2;     // iPad Pro (12.9-inch, 2nd generation)

    if ([ppdeviceModel isEqualToString:@"iPad6,12"])      return PPDeviceModelID_iPad_5;     // iPad Pro 12.9-Inch (Wi-Fi/Cellular)
    if ([ppdeviceModel isEqualToString:@"iPad6,11"])      return PPDeviceModelID_iPad_5;     // iPad Pro 12.9-Inch (Wi-Fi/Cellular)

    if ([ppdeviceModel isEqualToString:@"iPad7,4"])      return PPDeviceModelID_iPad_Pro;     // iPad Pro (10.5-inch)
    if ([ppdeviceModel isEqualToString:@"iPad7,3"])      return PPDeviceModelID_iPad_Pro;     // iPad Pro (10.5-inch)
    if ([ppdeviceModel isEqualToString:@"iPad6,8"])      return PPDeviceModelID_iPad_Pro;     // iPad Pro 12.9-Inch (Wi-Fi/Cellular)
    if ([ppdeviceModel isEqualToString:@"iPad6,7"])      return PPDeviceModelID_iPad_Pro;     // iPad Pro 12.9-Inch (Wi-Fi Only)
    if ([ppdeviceModel isEqualToString:@"iPad6,4"])      return PPDeviceModelID_iPad_Pro;     // iPad Pro 9.7-Inch (Wi-Fi/Cellular)
    if ([ppdeviceModel isEqualToString:@"iPad6,3"])      return PPDeviceModelID_iPad_Pro;     // iPad Pro 9.7-Inch (Wi-Fi Only)
    
    if ([ppdeviceModel isEqualToString:@"iPad5,4"])      return PPDeviceModelID_iPad_Air2;     // iPad Air 2 (Wi-Fi/Cellular)
    if ([ppdeviceModel isEqualToString:@"iPad5,3"])      return PPDeviceModelID_iPad_Air2;     // iPad Air 2 (Wi-Fi Only)
    
    if ([ppdeviceModel isEqualToString:@"iPad5,2"])      return PPDeviceModelID_iPad_mini4;     //  iPad mini 4 (Wi-Fi/Cellular)
    if ([ppdeviceModel isEqualToString:@"iPad5,1"])      return PPDeviceModelID_iPad_mini4;     // iPad mini 4 (Wi-Fi Only)
    if ([ppdeviceModel isEqualToString:@"iPad4,9"])      return PPDeviceModelID_iPad_mini3;     // (Wi-Fi/Cellular, China)
    if ([ppdeviceModel isEqualToString:@"iPad4,8"])      return PPDeviceModelID_iPad_mini3;     // iPad mini 3 (Wi-Fi/Cellular)
    if ([ppdeviceModel isEqualToString:@"iPad4,7"])      return PPDeviceModelID_iPad_mini3;     // iPad mini 3 (Wi-Fi Only)
    if ([ppdeviceModel isEqualToString:@"iPad4,6"])      return PPDeviceModelID_iPad_mini2;     // iPad mini (Retina/2nd Gen - China)
	if ([ppdeviceModel isEqualToString:@"iPad4,5"])      return PPDeviceModelID_iPad_mini2;     // iPad mini (Retina/2nd Gen - Wi-Fi/Cellular)
	if ([ppdeviceModel isEqualToString:@"iPad4,4"])      return PPDeviceModelID_iPad_mini2;     // iPad mini (Retina/2nd Gen - Wi-Fi Only)
    
    if ([ppdeviceModel isEqualToString:@"iPad4,3"])      return PPDeviceModelID_iPad_Air;     // iPad Air (Wi-Fi/TD-LTE - China)
	if ([ppdeviceModel isEqualToString:@"iPad4,2"])      return PPDeviceModelID_iPad_Air;     // iPad Air (Wi-Fi/Cellular)
	if ([ppdeviceModel isEqualToString:@"iPad4,1"])      return PPDeviceModelID_iPad_Air;     // iPad Air (Wi-Fi Only)
	if ([ppdeviceModel isEqualToString:@"iPad3,6"])      return PPDeviceModelID_iPad_4;     // ipad 4rd gen (wifi/verizon & sprint/GPS)
	if ([ppdeviceModel isEqualToString:@"iPad3,5"])      return PPDeviceModelID_iPad_4;     // ipad 4rd gen (wifi/AT&T/GPS)
	if ([ppdeviceModel isEqualToString:@"iPad3,4"])      return PPDeviceModelID_iPad_4;     // ipad 4rd gen (wifi only)
	if ([ppdeviceModel isEqualToString:@"iPad3,3"])      return PPDeviceModelID_iPad_3;     // ipad 3rd gen (wifi/AT&T/GPS)
	if ([ppdeviceModel isEqualToString:@"iPad3,2"])      return PPDeviceModelID_iPad_3;     // ipad 3rd gen (wifi/verizon/GPS)
	if ([ppdeviceModel isEqualToString:@"iPad3,1"])      return PPDeviceModelID_iPad_3;     // ipad 4rd gen (wifi only)
    
	if ([ppdeviceModel isEqualToString:@"iPad2,7"])      return PPDeviceModelID_iPad_mini;  // ipad mini (wifi/verizon & sprint/GPS)
	if ([ppdeviceModel isEqualToString:@"iPad2,6"])      return PPDeviceModelID_iPad_mini;  // ipad mini (wifi/AT&T/GPS)
	if ([ppdeviceModel isEqualToString:@"iPad2,5"])      return PPDeviceModelID_iPad_mini;  // ipad mini (wifi only)
    
	if ([ppdeviceModel isEqualToString:@"iPad2,4"])      return PPDeviceModelID_iPad_2;
	if ([ppdeviceModel isEqualToString:@"iPad2,3"])      return PPDeviceModelID_iPad_2;
    if ([ppdeviceModel isEqualToString:@"iPad2,2"])      return PPDeviceModelID_iPad_2;
    if ([ppdeviceModel isEqualToString:@"iPad2,1"])      return PPDeviceModelID_iPad_2;
    if ([ppdeviceModel isEqualToString:@"iPad1,1"])      return PPDeviceModelID_iPad_1;

    // undefined ipad model
    if ([ppdeviceModel hasPrefix:@"iPad"])               return PPDeviceModelID_iPad;

	// iPod
    if ([ppdeviceModel isEqualToString:@"iPod9,1"])      return PPDeviceModelID_iPod_7G;
    if ([ppdeviceModel isEqualToString:@"iPod7,1"])      return PPDeviceModelID_iPod_6G;        //iPod touch (6th Gen, 2015)
    if ([ppdeviceModel isEqualToString:@"iPod5,1"])      return PPDeviceModelID_iPod_5G;
    if ([ppdeviceModel isEqualToString:@"iPod4,1"])      return PPDeviceModelID_iPod_4G;
	if ([ppdeviceModel isEqualToString:@"iPod3,1"])      return PPDeviceModelID_iPod_3G;
    if ([ppdeviceModel isEqualToString:@"iPod2,2"])      return PPDeviceModelID_iPod_2_5G;
    if ([ppdeviceModel isEqualToString:@"iPod2,1"])      return PPDeviceModelID_iPod_2G;
    if ([ppdeviceModel isEqualToString:@"iPod1,1"])      return PPDeviceModelID_iPod_1G;

    // undefined ipod model
    if ([ppdeviceModel hasPrefix:@"iPod"])               return PPDeviceModelID_iPod;

	// AppleTV
    if ([ppdeviceModel isEqualToString:@"AppleTV11,1"])   return PPDeviceModelID_AppleTV_4K2;       // Apple TV 4K (2nd generation)
    if ([ppdeviceModel isEqualToString:@"AppleTV6,2"])   return PPDeviceModelID_AppleTV_4K;       // Apple TV 4K
    if ([ppdeviceModel isEqualToString:@"AppleTV5,3"])   return PPDeviceModelID_AppleTV4;       // Apple TV (4th Generation, Siri)
    if ([ppdeviceModel isEqualToString:@"AppleTV3,2"])   return PPDeviceModelID_AppleTV3;       // Apple TV (3rd Generation, Early 2013)
	if ([ppdeviceModel isEqualToString:@"AppleTV3,1"])   return PPDeviceModelID_AppleTV3;       // Apple TV (3rd Generation, Early 2012)
	if ([ppdeviceModel isEqualToString:@"AppleTV2,1"])   return PPDeviceModelID_AppleTV2;
	if ([ppdeviceModel isEqualToString:@"AppleTV1,1"])   return PPDeviceModelID_AppleTV1;
	
    // undefined ipod model
    if ([ppdeviceModel hasPrefix:@"AppleTV"])            return PPDeviceModelID_AppleTV;

	// simulator
	if ([ppdeviceModel isEqualToString:@"i386"])         return PPDeviceModelID_Simulator;
	if ([ppdeviceModel isEqualToString:@"x86_64"])       return PPDeviceModelID_Simulator;
	
	return PPDeviceModelID_Unknown;
}


//==============================================================================
//
//==============================================================================
+ (BOOL)hasHomeIndicator
{
    BOOL result = NO;
    
    PPDeviceModelID deviceID = [UIDevice deviceModelID];
    
    if((deviceID>=PPDeviceModelID_iPhone_X     && deviceID<PPDeviceModelID_iPad) ||
       deviceID==PPDeviceModelID_Simulator)
    {
        result = YES;
    }
    
    return result;
}


@end
