//
//  UIColor+HexString.m
//  
//

#import "UIColor+HexString.h"

@implementation UIColor (HexString)

//================================================================================
//
//================================================================================
+ (UIColor *)colorWithHexString:(NSString *)hexString
{
    return [self colorWithHexString:hexString
                              alpha:1.0f];
}


//================================================================================
//
//================================================================================
+ (UIColor *)colorWithHexString:(NSString *)hexString
                          alpha:(CGFloat)alpha
{
    if([hexString hasPrefix:@"#"] == YES)
    {
        NSString *valueString = [hexString stringByReplacingOccurrencesOfString:@"#" withString:@""];
        
        unsigned rgbValue = 0;
        NSScanner *scanner = [NSScanner scannerWithString:valueString];
        
        [scanner setScanLocation:0];
        [scanner scanHexInt:&rgbValue];
        
        return [UIColor colorWithRed:((rgbValue & 0xFF0000) >> 16)/255.0
                               green:((rgbValue & 0xFF00) >> 8)/255.0
                                blue:(rgbValue & 0xFF)/255.0
                               alpha:alpha];
    }
    
    return nil;
}
@end
