//
//  UIButton+Additions.h
//  
//
//  Created by Mike on 13/5/17.
//  
//

#import <UIKit/UIKit.h>
#import "UIImage+Additions.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#define UIButtonAdditions_TransformAnimationDuration        0.5	//旋轉動畫效果的duration

////////////////////////////////////////////////////////////////////////////////////////////////////

#define UIButtonAdditions_DefaultMinHeight                  30
#define UIButtonAdditions_DefaultMinWidth                   48
#define UIButtonAdditions_DefaultMaxWidth                   200

////////////////////////////////////////////////////////////////////////////////////////////////////

#define UIButtonAdditions_SmallRect                         CGRectMake(0, 0, UIButtonAdditions_DefaultMinWidth,		UIButtonAdditions_DefaultMinHeight)
#define UIButtonAdditions_MediumRect						CGRectMake(0, 0, UIButtonAdditions_DefaultMinWidth+20,	UIButtonAdditions_DefaultMinHeight)
#define UIButtonAdditions_LargeRect                         CGRectMake(0, 0, UIButtonAdditions_DefaultMinWidth+40,	UIButtonAdditions_DefaultMinHeight)
#define UIButtonAdditions_DefaultRect						UIButtonAdditions_SmallRect

////////////////////////////////////////////////////////////////////////////////////////////////////

#define UIButtonAdditions_DefaultTitleLabelMinHeight        UIButtonAdditions_DefaultMinHeight
#define UIButtonAdditions_DefaultTitleLabelMinWidth         UIButtonAdditions_DefaultMinWidth

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface UIButton (Additions)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

- (void)setBackgroundImage:(UIImage *)image;
- (void)setBackgroundImageWithName:(NSString *)name;
- (void)setImage:(UIImage *)image;
- (void)setImageTransformByOrientation:(UIDeviceOrientation)orientation;
- (void)setImageWithName:(NSString *)name;
- (void)setTitleText:(NSString *)title;
- (void)setTitle:(NSString *)title __deprecated_msg("Use setTitleText: instead");
- (void)setTitle:(NSString *)title maxWidth:(CGFloat)maxWidth;
- (void)setTitleColor:(UIColor *)color;
- (void)setTitleShadowColor:(UIColor *)color;

@end
