//
//  UIApplication+Idle.m
//  WorldCardCloud
//
//  Created by Eddie on 2014/7/7.
//  Copyright (c) 2014年 Penpower. All rights reserved.
//

#import <objc/runtime.h>
#import "UIApplication+Idle.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

static char UIApplication_IdleDisableCount;

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation UIApplication (Idle)

//================================================================================
//
//================================================================================
- (int)idleDisableCount
{
    id value = objc_getAssociatedObject(self, &UIApplication_IdleDisableCount);
    
    if(value)
    {
        return [value intValue];
    }
    
    return 0;
}


//================================================================================
//
//================================================================================
- (void)setIdleDisableCount:(int)count
{
    objc_setAssociatedObject(self, &UIApplication_IdleDisableCount, [NSNumber numberWithInt:count], OBJC_ASSOCIATION_RETAIN_NONATOMIC);
}


//================================================================================
// 概念同retainCount
//================================================================================
- (void)enableIdle:(BOOL)enable
{
    @synchronized(self)
    {
        int idleDisableCount = [self idleDisableCount];
        
        if(enable)
        {
            if(idleDisableCount > 0)
            {
                idleDisableCount--;
                [self setIdleDisableCount:idleDisableCount];
            }
            
            if(idleDisableCount == 0)
            {
                dispatch_async(dispatch_get_main_queue(), ^{
                    // 這個要在main thread處理
                    self.idleTimerDisabled = NO;
                });
            }
        }
        else // disable
        {
            if(idleDisableCount == 0)
            {
                dispatch_async(dispatch_get_main_queue(), ^{
                    // 這個要在main thread處理
                    self.idleTimerDisabled = YES;
                });
            }

            idleDisableCount++;
            [self setIdleDisableCount:idleDisableCount];
        }
        
//        NSLog(@"idleDisableCount %d", idleDisableCount);
    }
}


@end
