//
//  PHAssetCollection+Image.m
//  WCNewCardFlowController
//
//  Created by sanhue cheng on 2020/10/8.
//

#import "PHAssetCollection+Image.h"
#import "PHFetchOptionsHelper.h"
#import "PHAsset+Image.h"

@implementation PHAssetCollection (Image)


//==============================================================================
//
//==============================================================================
- (void)fetchPosterImageWithcompleteHandler:(void(^)(UIImage *result))completeHandler
{
    PHFetchOptions *fetchOption = [PHFetchOptionsHelper photosFetchOptions];
    // 相簿圖片，只取一張
    fetchOption.fetchLimit = 1;
    
    PHFetchResult *fetchResult = [PHAsset fetchKeyAssetsInAssetCollection:self options:fetchOption];
    
    if(fetchResult==nil)
    {
        if(completeHandler)
        {
            //////////////////////////////////////////////////
            dispatch_async(dispatch_get_main_queue(), ^{
                completeHandler(nil);
            });
        }
        
        return ;
    }
    
    //////////////////////////////////////////////////
    PHAsset *asset = [fetchResult firstObject];
    
    [asset fetchThumbnailImageWithCompleteHandler:completeHandler];
}

@end
