//
//  NSString+UTF32.m
//  WorldNote
//
//  Created by sanhue cheng on 13/10/2.
//  Modify by Andrew Lai on 14/5/16.
//  Copyright (c) 2013年 Eddie. All rights reserved.
//

#import "NSString+UTF32.h"
#import "NSString+Additions.h"

@implementation NSString (UTF32)


//================================================================================
//
//================================================================================
- (NSUInteger)characterCount
{
    __block NSUInteger characterCount = 0;
    
    [self enumerateSubstringsInRange:NSMakeRange(0, [self length]) options:NSStringEnumerationByComposedCharacterSequences usingBlock:
     ^(NSString *substring, NSRange substringRange, NSRange enclosingRange, BOOL *stop) {
         
         characterCount++;
         
     }];
    
    return characterCount;
}


//================================================================================
//
//================================================================================
-(NSRange)rangeOfStringAtUTF32Index:(NSUInteger)utf32Index
{
    __block NSRange currentRange = NSMakeRange(NSNotFound, 0);
    
    __block int currentUTF32Index = 0;
    
    [self enumerateSubstringsInRange:NSMakeRange(0, [self length]) options:NSStringEnumerationByComposedCharacterSequences usingBlock:
     ^(NSString *substring, NSRange substringRange, NSRange enclosingRange, BOOL *stop) {
         
         if (currentUTF32Index == utf32Index)
         {
            currentRange = enclosingRange;
         }
         
         currentUTF32Index++;
         
     }];
    
    return currentRange;
}


//==============================================================================
//
//==============================================================================
- (NSString *)substringWithUTF32Range:(NSRange)utf32Range
{
    NSRange utf8Range = [self utf8RangeFromUTF32Range:utf32Range];
    
    return [self substringWithRange:utf8Range];
}


//================================================================================
//
//================================================================================
- (NSInteger)utf32IndexFromUTF8Index:(NSUInteger)utf8Index
{
    
    
    __block NSInteger utf32Index = -1;
    __block int substringIndex = 0;
    
    [self enumerateSubstringsInRange:NSMakeRange(0, [self length]) options:NSStringEnumerationByComposedCharacterSequences usingBlock:
     ^(NSString *substring, NSRange substringRange, NSRange enclosingRange, BOOL *stop) {
         
         // 由於核心取得的泰文複合文字與系統NSStringEnumberationByComposedCharacterSequences的文字數計算方式是不一致的
         // (核心的複合文字會拆成兩個字計算，但是Apple會將它合併為一個字元
         // 所以這邊在遇上泰文時substringIndex的計算要獨立處理
         if([substring isThai])
         {
             if(enclosingRange.location<=utf8Index && utf8Index<enclosingRange.location+enclosingRange.length)
             {
                 // 計算UTF32Index的方式在泰文底下也要改變
                 
                 utf32Index = utf8Index;
             }
             
             substringIndex += substringRange.length;
         }
         else
         {
             if(enclosingRange.location<=utf8Index && utf8Index<enclosingRange.location+enclosingRange.length)
             {
                 utf32Index = substringIndex;
             }
             
             substringIndex ++;
         }
     }];
    
    return utf32Index;
}


//==============================================================================
//
//==============================================================================
- (NSRange)utf8RangeFromUTF32Range:(NSRange)utf32Range
{
    //////////////////////////////////////////////////
    // 第一個字的utf8 range
    
    
    NSUInteger utf8Location = 0;
    if (utf32Range.location>0)
    {
        NSRange tempRange = [self rangeOfStringAtUTF32Index:utf32Range.location-1];
        utf8Location = tempRange.location+tempRange.length;
        
        NSLog(@"utf8Location:%td tempRange:%@", utf8Location, NSStringFromRange(tempRange));
    }
    
    
    
    //////////////////////////////////////////////////
    // 最後一個字的utf8 range
    NSUInteger utf8Length = 0;
    if (utf32Range.length>0)
    {
        NSRange tempRange = [self rangeOfStringAtUTF32Index:utf32Range.location+utf32Range.length-1];
        // utf8的上界，減掉utf8Location就是utf8 range 的 length
        utf8Length = tempRange.location+tempRange.length-utf8Location;
        
        NSLog(@"utf8Length:%td tempRange:%@", utf8Length, NSStringFromRange(tempRange));
    }
    
    return NSMakeRange(utf8Location, utf8Length);
}


//================================================================================
//
//================================================================================
- (NSString *)swapedStringFromIndex:(NSUInteger)fromIndex toIndex:(NSUInteger)toIndex
{
    if (fromIndex >= [self characterCount] || toIndex >= [self characterCount]) return nil;
    
    //    NSRange rangeOfFromChar = [self rangeOfComposedCharacterSequenceAtIndex:fromIndex];
    //    NSRange rangeOfToChar = [self rangeOfComposedCharacterSequenceAtIndex:toIndex];
    NSRange rangeOfFromChar = [self rangeOfStringAtUTF32Index:fromIndex];
    NSRange rangeOfToChar = [self rangeOfStringAtUTF32Index:toIndex];
    
    NSString *fromString = [self substringWithRange:rangeOfFromChar];
    NSString *toString = [self substringWithRange:rangeOfToChar];
    
    __block NSMutableString *swapedString = [NSMutableString stringWithCapacity:self.length];
    
    [self enumerateSubstringsInRange:NSMakeRange(0, self.length)
                             options:NSStringEnumerationByComposedCharacterSequences
                          usingBlock:^(NSString *substring, NSRange substringRange, NSRange enclosingRange, BOOL *stop)
     {
         if (NSEqualRanges(substringRange, rangeOfFromChar))
         {
             [swapedString appendString:toString];
         }
         else if (NSEqualRanges(substringRange, rangeOfToChar))
         {
             [swapedString appendString:fromString];
         }
         else
         {
             [swapedString appendString:substring];
         }
         
     }];
    
    return [NSString stringWithString:swapedString];
}


@end
