//
//  NSFileManager+Additions.m
//  
//
//  Created by Mike on 13/5/8.
//  
//

#import "NSFileManager+Additions.h"

@implementation NSFileManager (Additions)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

//================================================================================
//
//================================================================================
- (BOOL)createDirectoryAtPath:(NSString *)path error:(NSError **)error
{
    return [self createDirectoryAtPath:path withIntermediateDirectories:YES attributes:nil error:error];
}

//================================================================================
//
//================================================================================
- (BOOL)removeContentsAtPath:(NSString *)path error:(NSError **)error
{
    BOOL result = YES;
    
    do
    {
        NSArray *contents = [self contentsOfDirectoryAtPath:path error:error];
        if(contents==nil)
        {
            result = NO;
            break;
        }

        //////////////////////////////////////////////////
        
        for(NSString *content in contents)
        {
            if([self removeItemAtPath:[path stringByAppendingPathComponent:content] error:error]==NO)
            {
                result = NO;
                break;
            }
        }
          
    }while(0);
    
    return result;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

//================================================================================
//
//================================================================================
+ (BOOL)createDirectoryAtPath:(NSString *)path error:(NSError **)error
{
    BOOL result = NO;
    
    do
    {
        NSFileManager *fileManager = [NSFileManager defaultManager];
        if(fileManager==nil)
        {
            if(error!=nil && *error!=nil)
            {
                *error = PPErrorOperationFailed(nil);
            }
            
            break;
        }
        
        //////////////////////////////////////////////////
        
        result = [fileManager createDirectoryAtPath:path error:error];
        
    }while(0);
    
    return result;
}

//================================================================================
//
//================================================================================
+ (BOOL)copyItemAtPath:(NSString *)atPath toPath:(NSString *)toPath error:(NSError **)error
{
    BOOL result = NO;
    
    do
    {
        NSFileManager *fileManager = [NSFileManager defaultManager];
        if(fileManager==nil)
        {
            if(error!=nil && *error!=nil)
            {
                *error = PPErrorOperationFailed(nil);
            }
            
            break;
        }
        
        //////////////////////////////////////////////////
        
        result = [fileManager copyItemAtPath:atPath toPath:toPath error:error];
        
    }while(0);
    
    return result;
}

//================================================================================
//
//================================================================================
+ (BOOL)moveItemAtPath:(NSString *)atPath toPath:(NSString *)toPath error:(NSError **)error
{
    BOOL result = NO;
    
    do
    {
        NSFileManager *fileManager = [NSFileManager defaultManager];
        if(fileManager==nil)
        {
            if(error!=nil && *error!=nil)
            {
                *error = PPErrorOperationFailed(nil);
            }

            break;
        }
        
        //////////////////////////////////////////////////
        
        result = [fileManager moveItemAtPath:atPath toPath:toPath error:error];
        
    }while(0);
    
    return result;
}

//================================================================================
//
//================================================================================
+ (BOOL)removeItemAtPath:(NSString *)path error:(NSError **)error
{
    BOOL result = NO;
    
    do
    {
        NSFileManager *fileManager = [NSFileManager defaultManager];
        if(fileManager==nil)
        {
            if(error!=nil && *error!=nil)
            {
                *error = PPErrorOperationFailed(nil);
            }
            
            break;
        }
        
        //////////////////////////////////////////////////
        
        result = [fileManager removeItemAtPath:path error:error];
        
    }while(0);
    
    return result;
}

//================================================================================
//
//================================================================================
+ (BOOL)removeContentsAtPath:(NSString *)path error:(NSError **)error
{
    BOOL result = NO;
    
    do
    {
        NSFileManager *fileManager = [NSFileManager defaultManager];
        if(fileManager==nil)
        {
            if(error!=nil && *error!=nil)
            {
                *error = PPErrorOperationFailed(nil);
            }
            
            break;
        }
        
        //////////////////////////////////////////////////
        
        result = [fileManager removeContentsAtPath:path error:error];
        
    }while(0);
    
    return result;
}


//================================================================================
//
//================================================================================
+ (unsigned long long)folderSize:(NSString *)folderPath
{
    NSArray *filesArray = [[NSFileManager defaultManager] subpathsOfDirectoryAtPath:folderPath error:nil];
    NSEnumerator *filesEnumerator = [filesArray objectEnumerator];
    NSString *fileName;
    unsigned long long fileSize = 0;
    
    while (fileName = [filesEnumerator nextObject])
    {
        NSDictionary *fileDictionary = [[NSFileManager defaultManager] attributesOfItemAtPath:[folderPath stringByAppendingPathComponent:fileName] error:nil];
        fileSize += [fileDictionary fileSize];
    }
    
    return fileSize;
}


//================================================================================
//
//================================================================================
+ (unsigned long long)diskFreeSizeWithPath:(NSString *)path
{
    //////////////////////////////////////////////////
    // 找出存在的folder

    NSString *checkPath = [[path copy] autorelease];
    
    while (true)
    {
        BOOL isDirectory = NO;
        
        if([[self defaultManager] fileExistsAtPath:checkPath isDirectory:&isDirectory] == YES && isDirectory == YES)
        {
            break;
        }
        else
        {
            NSMutableArray *compoments = [NSMutableArray arrayWithArray:[checkPath pathComponents]];
            [compoments removeLastObject];
            checkPath = [NSString pathWithComponents:compoments];
        }
    }
    
    
    //////////////////////////////////////////////////
    // 取得空間資料

    unsigned long long freeSize = 0;
    NSError *error = nil;
    NSDictionary *dictionary = [[NSFileManager defaultManager] attributesOfFileSystemForPath:checkPath error:&error];
    
    if (dictionary != nil)
    {
        NSNumber *freeFileSystemSizeInBytes = [dictionary objectForKey:NSFileSystemFreeSize];
        freeSize = [freeFileSystemSizeInBytes unsignedLongLongValue];
    }

    return freeSize;
}


//================================================================================
//
//================================================================================
+ (BOOL)hasEnoughDiskSpaceWithSize:(unsigned long long)requestSize
{
    NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
    unsigned long long freeSize = [self diskFreeSizeWithPath:[paths lastObject]];

    return (freeSize >= requestSize);
}


//================================================================================
//
//================================================================================
+ (unsigned long long)fileSizeWithPath:(NSString *)path error:(NSError **)error
{
    NSError *returnError = nil;
    
    NSURL *fileURL = [NSURL fileURLWithPath:path];
    NSNumber *fileSizeValue = nil;

    [fileURL getResourceValue:&fileSizeValue
                       forKey:NSURLFileSizeKey
                        error:&returnError];
    
    if(error!=nil)
    {
        *error = returnError;
    }

    return fileSizeValue.unsignedLongLongValue;
}
@end
