//
//  NSDate+TimeSection.m
//  Pods
//
//  Created by sanhue on 2016/12/6.
//
//

#import "NSDate+TimeSection.h"
#import "NSString+Additions.h"

@implementation NSDate (TimeSection)


#pragma mark ##### time section title handler #####



//==============================================================================
// default section Title, Format: yyyy.MM.dd
//==============================================================================
- (NSString *)sectionTitle
{
    return [self sectionTitleWithDateSeparator:nil];
}


//================================================================================
// 使用日期產生sectionTitle
// 規則:
// 1。與今天同一週的，一天一個title
// 2。與今天同一個月，但不同週的，為本月
// 3。與今天不同月份的，以月為單位，一個月一個title
//================================================================================
- (NSString *)sectionTitleWithDateSeparator:(NSString *)dateSeparator
{
    NSString *title = [NSDateFormatter localizedStringFromDate:self
                                                     dateStyle:NSDateFormatterShortStyle
                                                     timeStyle:NSDateFormatterNoStyle];
    
    do
    {
        //取得今天年月日
        NSDateComponents *nowComponents = [[NSCalendar currentCalendar] components:NSCalendarUnitYear|NSCalendarUnitMonth|NSCalendarUnitDay|NSCalendarUnitWeekdayOrdinal
                                                                          fromDate:[NSDate date]];
        if(nowComponents==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSDateComponents *dateComponents = [[NSCalendar currentCalendar] components:NSCalendarUnitYear|NSCalendarUnitMonth|NSCalendarUnitDay|NSCalendarUnitWeekdayOrdinal
                                                                           fromDate:self];
        if(dateComponents==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
        
        if(nowComponents.year==dateComponents.year &&
           nowComponents.month==dateComponents.month &&
           nowComponents.weekdayOrdinal==dateComponents.weekdayOrdinal)
        {
            NSString *format = @"yyyy.MM.dd";
            if ([dateSeparator length]>0)
            {
                format = [format stringByReplacingOccurrencesOfString:@"." withString:dateSeparator];
            }
            
            [dateFormatter setDateFormat:format];
            
            title = [dateFormatter stringFromDate:self];
        }
        else if(nowComponents.year==dateComponents.year &&
                nowComponents.month==dateComponents.month)
        {
            title = [@"MLS_ThisMonth" localized];
        }
        else
        {
            NSString *format = @"yyyy.MM";
            if ([dateSeparator length]>0)
            {
                format = [format stringByReplacingOccurrencesOfString:@"." withString:dateSeparator];
            }
            
            [dateFormatter setDateFormat:format];
            
            title = [dateFormatter stringFromDate:self];
        }
        
        
        [dateFormatter release];
    }
    while (0);
    
    return title;
}
@end
